/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.prestosql.hive.jdbc.;
import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobStatus;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class JobEndNotifier {
    private static final Log LOG = LogFactory.getLog(JobEndNotifier.class.getName());
    private static Thread thread;
    private static volatile boolean running;
    private static BlockingQueue<JobEndStatusInfo> queue;

    public static void startNotifier() {
        running = true;
        thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        while (running) {
                            this.sendNotification((JobEndStatusInfo)queue.take());
                        }
                    }
                    catch (InterruptedException irex) {
                        if (!running) break block3;
                        LOG.error("Thread has ended unexpectedly", irex);
                    }
                }
            }

            private void sendNotification(JobEndStatusInfo notification) {
                try {
                    int code = JobEndNotifier.httpNotification(notification.getUri());
                    if (code != 200) {
                        throw new IOException("Invalid response status code: " + code);
                    }
                }
                catch (IOException ioex) {
                    LOG.error("Notification failure [" + notification + "]", ioex);
                    if (notification.configureForRetry()) {
                        try {
                            queue.put(notification);
                        }
                        catch (InterruptedException iex) {
                            LOG.error("Notification queuing error [" + notification + "]", iex);
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error("Notification failure [" + notification + "]", ex);
                }
            }
        });
        thread.start();
    }

    public static void stopNotifier() {
        running = false;
        thread.interrupt();
    }

    private static JobEndStatusInfo createNotification(JobConf conf, JobStatus status) {
        JobEndStatusInfo notification = null;
        String uri = conf.getJobEndNotificationURI();
        if (uri != null) {
            int retryAttempts = conf.getInt("job.end.retry.attempts", 0) + 1;
            long retryInterval = conf.getInt("job.end.retry.interval", 30000);
            if (uri.contains("$jobId")) {
                uri = uri.replace("$jobId", status.getJobID().toString());
            }
            if (uri.contains("$jobStatus")) {
                String statusStr = status.getRunState() == 2 ? "SUCCEEDED" : (status.getRunState() == 3 ? "FAILED" : "KILLED");
                uri = uri.replace("$jobStatus", statusStr);
            }
            notification = new JobEndStatusInfo(uri, retryAttempts, retryInterval);
        }
        return notification;
    }

    public static void registerNotification(JobConf jobConf, JobStatus status) {
        JobEndStatusInfo notification = JobEndNotifier.createNotification(jobConf, status);
        if (notification != null) {
            try {
                queue.put(notification);
            }
            catch (InterruptedException iex) {
                LOG.error("Notification queuing failure [" + notification + "]", iex);
            }
        }
    }

    private static int httpNotification(String uri) throws IOException {
        .URI url = new .URI(uri, false);
        .HttpClient m_client = new .HttpClient();
        .GetMethod method = new .GetMethod(url.getEscapedURI());
        method.setRequestHeader("Accept", "*/*");
        return m_client.executeMethod((.HttpMethod)method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void localRunnerNotification(JobConf conf, JobStatus status) {
        JobEndStatusInfo notification = JobEndNotifier.createNotification(conf, status);
        if (notification != null) {
            while (notification.configureForRetry()) {
                try {
                    int code = JobEndNotifier.httpNotification(notification.getUri());
                    if (code != 200) {
                        throw new IOException("Invalid response status code: " + code);
                    }
                    break;
                }
                catch (IOException ioex) {
                    LOG.error("Notification error [" + notification.getUri() + "]", ioex);
                }
                catch (Exception ex) {
                    LOG.error("Notification error [" + notification.getUri() + "]", ex);
                }
                try {
                    Thread ex = Thread.currentThread();
                    synchronized (ex) {
                        Thread.currentThread();
                        Thread.sleep(notification.getRetryInterval());
                    }
                }
                catch (InterruptedException iex) {
                    LOG.error("Notification retry error [" + notification + "]", iex);
                }
            }
        }
    }

    static {
        queue = new DelayQueue<JobEndStatusInfo>();
    }

    private static class JobEndStatusInfo
    implements Delayed {
        private String uri;
        private int retryAttempts;
        private long retryInterval;
        private long delayTime;

        JobEndStatusInfo(String uri, int retryAttempts, long retryInterval) {
            this.uri = uri;
            this.retryAttempts = retryAttempts;
            this.retryInterval = retryInterval;
            this.delayTime = System.currentTimeMillis();
        }

        public String getUri() {
            return this.uri;
        }

        public int getRetryAttempts() {
            return this.retryAttempts;
        }

        public long getRetryInterval() {
            return this.retryInterval;
        }

        public long getDelayTime() {
            return this.delayTime;
        }

        public boolean configureForRetry() {
            boolean retry = false;
            if (this.getRetryAttempts() > 0) {
                retry = true;
                this.delayTime = System.currentTimeMillis() + this.retryInterval;
            }
            --this.retryAttempts;
            return retry;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long n = this.delayTime - System.currentTimeMillis();
            return unit.convert(n, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed d) {
            return (int)(this.delayTime - ((JobEndStatusInfo)d).delayTime);
        }

        public boolean equals(Object o) {
            if (!(o instanceof JobEndStatusInfo)) {
                return false;
            }
            return this.delayTime == ((JobEndStatusInfo)o).delayTime;
        }

        public int hashCode() {
            return 629 + (int)(this.delayTime ^ this.delayTime >>> 32);
        }

        public String toString() {
            return "URL: " + this.uri + " remaining retries: " + this.retryAttempts + " interval: " + this.retryInterval;
        }
    }
}

