/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.prestosql.hive.jdbc.;
import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.SpillRecord;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

class IndexCache {
    private final JobConf conf;
    private final int totalMemoryAllowed;
    private AtomicInteger totalMemoryUsed = new AtomicInteger();
    private static final Log LOG = LogFactory.getLog(IndexCache.class);
    private final ConcurrentHashMap<String, IndexInformation> cache = new ConcurrentHashMap();
    private final LinkedBlockingQueue<String> queue = new LinkedBlockingQueue();

    public IndexCache(JobConf conf) {
        this.conf = conf;
        this.totalMemoryAllowed = conf.getInt("mapred.tasktracker.indexcache.mb", 10) * 1024 * 1024;
        LOG.info("IndexCache created with max memory = " + this.totalMemoryAllowed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public .IndexRecord getIndexInformation(String mapId, int reduce, Path fileName) throws IOException {
        IndexInformation info = this.cache.get(mapId);
        if (info == null) {
            info = this.readIndexFileToCache(fileName, mapId);
        } else {
            IndexInformation indexInformation = info;
            synchronized (indexInformation) {
                while (null == info.mapSpillRecord) {
                    try {
                        info.wait();
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted waiting for construction", e);
                    }
                }
            }
            LOG.debug("IndexCache HIT: MapId " + mapId + " found");
        }
        if (info.mapSpillRecord.size() == 0 || info.mapSpillRecord.size() < reduce) {
            throw new IOException("Invalid request  Map Id = " + mapId + " Reducer = " + reduce + " Index Info Length = " + info.mapSpillRecord.size());
        }
        return info.mapSpillRecord.getIndex(reduce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexInformation readIndexFileToCache(Path indexFileName, String mapId) throws IOException {
        IndexInformation newInd = new IndexInformation();
        IndexInformation info = this.cache.putIfAbsent(mapId, newInd);
        if (info != null) {
            IndexInformation indexInformation = info;
            synchronized (indexInformation) {
                while (null == info.mapSpillRecord) {
                    try {
                        info.wait();
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted waiting for construction", e);
                    }
                }
            }
            LOG.debug("IndexCache HIT: MapId " + mapId + " found");
            return info;
        }
        LOG.debug("IndexCache MISS: MapId " + mapId + " not found");
        SpillRecord tmp = null;
        try {
            tmp = new SpillRecord(indexFileName, this.conf);
        }
        catch (Throwable e) {
            tmp = new SpillRecord(0);
            this.cache.remove(mapId);
            throw new IOException("Error Reading IndexFile", e);
        }
        finally {
            IndexInformation e = newInd;
            synchronized (e) {
                newInd.mapSpillRecord = tmp;
                newInd.notifyAll();
            }
        }
        this.queue.add(mapId);
        if (this.totalMemoryUsed.addAndGet(newInd.getSize()) > this.totalMemoryAllowed) {
            this.freeIndexInformation();
        }
        return newInd;
    }

    public void removeMap(String mapId) {
        IndexInformation info = this.cache.remove(mapId);
        if (info != null) {
            this.totalMemoryUsed.addAndGet(-info.getSize());
            if (!this.queue.remove(mapId)) {
                LOG.warn("Map ID" + mapId + " not found in queue!!");
            }
        } else {
            LOG.info("Map ID " + mapId + " not found in cache");
        }
    }

    private synchronized void freeIndexInformation() {
        while (this.totalMemoryUsed.get() > this.totalMemoryAllowed) {
            String s = (String)this.queue.remove();
            IndexInformation info = this.cache.remove(s);
            if (info == null) continue;
            this.totalMemoryUsed.addAndGet(-info.getSize());
        }
    }

    private static class IndexInformation {
        SpillRecord mapSpillRecord;

        private IndexInformation() {
        }

        int getSize() {
            return this.mapSpillRecord == null ? 0 : this.mapSpillRecord.size() * 24;
        }
    }
}

