/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.ChecksumException;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.IOUtils;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.DataChecksum;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class IFileInputStream
extends InputStream {
    private final InputStream in;
    private final long length;
    private final long dataLength;
    private DataChecksum sum;
    private long currentOffset = 0L;
    private final byte[] b = new byte[1];
    private byte[] csum = null;
    private int checksumSize;

    public IFileInputStream(InputStream in, long len) {
        this.in = in;
        this.sum = DataChecksum.newDataChecksum(1, Integer.MAX_VALUE);
        this.checksumSize = this.sum.getChecksumSize();
        this.length = len;
        this.dataLength = this.length - (long)this.checksumSize;
    }

    @Override
    public void close() throws IOException {
        if (this.currentOffset < this.dataLength) {
            byte[] t = new byte[Math.min((int)(Integer.MAX_VALUE & this.dataLength - this.currentOffset), 32768)];
            while (this.currentOffset < this.dataLength) {
                int n = this.read(t, 0, t.length);
                if (0 != n) continue;
                throw new EOFException("Could not validate checksum");
            }
        }
        this.in.close();
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("Skip not supported for IFileInputStream");
    }

    public long getPosition() {
        return this.currentOffset >= this.dataLength ? this.dataLength : this.currentOffset;
    }

    public long getSize() {
        return this.checksumSize;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.currentOffset >= this.dataLength) {
            return -1;
        }
        return this.doRead(b, off, len);
    }

    public int readWithChecksum(byte[] b, int off, int len) throws IOException {
        if (this.currentOffset == this.length) {
            return -1;
        }
        if (this.currentOffset >= this.dataLength) {
            int lenToCopy = (int)((long)this.checksumSize - (this.currentOffset - this.dataLength));
            if (len < lenToCopy) {
                lenToCopy = len;
            }
            System.arraycopy(this.csum, (int)(this.currentOffset - this.dataLength), b, off, lenToCopy);
            this.currentOffset += (long)lenToCopy;
            return lenToCopy;
        }
        int bytesRead = this.doRead(b, off, len);
        if (this.currentOffset == this.dataLength && len >= bytesRead + this.checksumSize) {
            System.arraycopy(this.csum, 0, b, off + bytesRead, this.checksumSize);
            bytesRead += this.checksumSize;
            this.currentOffset += (long)this.checksumSize;
        }
        return bytesRead;
    }

    private int doRead(byte[] b, int off, int len) throws IOException {
        int bytesRead;
        if (this.currentOffset + (long)len > this.dataLength) {
            len = (int)this.dataLength - (int)this.currentOffset;
        }
        if ((bytesRead = this.in.read(b, off, len)) < 0) {
            throw new ChecksumException("Checksum Error", 0L);
        }
        this.sum.update(b, off, bytesRead);
        this.currentOffset += (long)bytesRead;
        if (this.currentOffset == this.dataLength) {
            this.csum = new byte[this.checksumSize];
            IOUtils.readFully(this.in, this.csum, 0, this.checksumSize);
            if (!this.sum.compare(this.csum, 0)) {
                throw new ChecksumException("Checksum Error", 0L);
            }
        }
        return bytesRead;
    }

    @Override
    public int read() throws IOException {
        this.b[0] = 0;
        int l = this.read(this.b, 0, 1);
        if (l < 0) {
            return l;
        }
        int result = 0xFF & this.b[0];
        return result;
    }

    public byte[] getChecksum() {
        return this.csum;
    }
}

