/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.prestosql.hive.jdbc.;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileSystem;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.compress.CompressionCodec;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.FileAlreadyExistsException;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.FileOutputCommitter;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.InvalidJobConfException;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.OutputCommitter;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.OutputFormat;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskAttemptContext;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskAttemptID;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.Progressable;
import java.io.IOException;
import java.text.NumberFormat;

public abstract class FileOutputFormat<K, V>
implements OutputFormat<K, V> {
    public static void setCompressOutput(JobConf conf, boolean compress) {
        conf.setBoolean("mapred.output.compress", compress);
    }

    public static boolean getCompressOutput(JobConf conf) {
        return conf.getBoolean("mapred.output.compress", false);
    }

    public static void setOutputCompressorClass(JobConf conf, Class<? extends CompressionCodec> codecClass) {
        FileOutputFormat.setCompressOutput(conf, true);
        conf.setClass("mapred.output.compression.codec", codecClass, CompressionCodec.class);
    }

    public static Class<? extends CompressionCodec> getOutputCompressorClass(JobConf conf, Class<? extends CompressionCodec> defaultValue) {
        Class<? extends CompressionCodec> codecClass = defaultValue;
        String name = conf.get("mapred.output.compression.codec");
        if (name != null) {
            try {
                codecClass = conf.getClassByName(name).asSubclass(CompressionCodec.class);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Compression codec " + name + " was not found.", e);
            }
        }
        return codecClass;
    }

    @Override
    public abstract .RecordWriter<K, V> getRecordWriter(FileSystem var1, JobConf var2, String var3, Progressable var4) throws IOException;

    @Override
    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws FileAlreadyExistsException, InvalidJobConfException, IOException {
        Path outDir = FileOutputFormat.getOutputPath(job);
        if (outDir == null && job.getNumReduceTasks() != 0) {
            throw new InvalidJobConfException("Output directory not set in JobConf.");
        }
        if (outDir != null) {
            FileSystem fs = outDir.getFileSystem(job);
            outDir = fs.makeQualified(outDir);
            FileOutputFormat.setOutputPath(job, outDir);
            if (fs.exists(outDir)) {
                throw new FileAlreadyExistsException("Output directory " + outDir + " already exists");
            }
        }
    }

    public static void setOutputPath(JobConf conf, Path outputDir) {
        outputDir = new Path(conf.getWorkingDirectory(), outputDir);
        conf.set("mapred.output.dir", outputDir.toString());
    }

    static void setWorkOutputPath(JobConf conf, Path outputDir) {
        outputDir = new Path(conf.getWorkingDirectory(), outputDir);
        conf.set("mapred.work.output.dir", outputDir.toString());
    }

    public static Path getOutputPath(JobConf conf) {
        String name = conf.get("mapred.output.dir");
        return name == null ? null : new Path(name);
    }

    public static Path getWorkOutputPath(JobConf conf) {
        String name = conf.get("mapred.work.output.dir");
        return name == null ? null : new Path(name);
    }

    public static Path getTaskOutputPath(JobConf conf, String name) throws IOException {
        Path outputPath = FileOutputFormat.getOutputPath(conf);
        if (outputPath == null) {
            throw new IOException("Undefined job output-path");
        }
        OutputCommitter committer = conf.getOutputCommitter();
        Path workPath = outputPath;
        TaskAttemptContext context = new TaskAttemptContext(conf, TaskAttemptID.forName(conf.get("mapred.task.id")));
        if (committer instanceof FileOutputCommitter) {
            workPath = ((FileOutputCommitter)committer).getWorkPath(context, outputPath);
        }
        return new Path(workPath, name);
    }

    public static String getUniqueName(JobConf conf, String name) {
        int partition = conf.getInt("mapred.task.partition", -1);
        if (partition == -1) {
            throw new IllegalArgumentException("This method can only be called from within a Job");
        }
        String taskType = conf.getBoolean("mapred.task.is.map", true) ? "m" : "r";
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumIntegerDigits(5);
        numberFormat.setGroupingUsed(false);
        return name + "-" + taskType + "-" + numberFormat.format(partition);
    }

    public static Path getPathForCustomFile(JobConf conf, String name) {
        return new Path(FileOutputFormat.getWorkOutputPath(conf), FileOutputFormat.getUniqueName(conf, name));
    }
}

