/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred;

import io.prestosql.hive.jdbc.;
import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FSError;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileSystem;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileUtil;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.ipc.RPC;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JVMId;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JvmTask;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.Task;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskAttemptID;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskLog;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskRunner;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.metrics.MetricsContext;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.metrics.MetricsUtil;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.metrics.jvm.JvmMetrics;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import org.apache.log4j.LogManager;

class Child {
    public static final Log LOG = LogFactory.getLog(.TaskTracker.class);
    static volatile TaskAttemptID taskid = null;
    static volatile boolean isCleanup;

    Child() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        LOG.debug("Child starting");
        JobConf defaultConf = new JobConf();
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        InetSocketAddress address = new InetSocketAddress(host, port);
        final TaskAttemptID firstTaskid = TaskAttemptID.forName(args[2]);
        int SLEEP_LONGER_COUNT = 5;
        int jvmIdInt = Integer.parseInt(args[3]);
        JVMId jvmId = new JVMId(firstTaskid.getJobID(), firstTaskid.isMap(), jvmIdInt);
        TaskUmbilicalProtocol umbilical = (TaskUmbilicalProtocol)RPC.getProxy(TaskUmbilicalProtocol.class, 16L, address, defaultConf);
        int numTasksToExecute = -1;
        int numTasksExecuted = 0;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    if (taskid != null) {
                        TaskLog.syncLogs(firstTaskid, taskid, isCleanup);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(5000L);
                            if (taskid == null) continue;
                            TaskLog.syncLogs(firstTaskid, taskid, isCleanup);
                        }
                    }
                    catch (InterruptedException ie) {
                        continue;
                    }
                    catch (IOException iee) {
                        LOG.error("Error in syncLogs: " + iee);
                        System.exit(-1);
                        continue;
                    }
                    break;
                }
            }
        };
        t.setName("Thread for syncLogs");
        t.setDaemon(true);
        t.start();
        Path srcPidPath = null;
        Path dstPidPath = null;
        int idleLoopCount = 0;
        Task task = null;
        try {
            while (true) {
                taskid = null;
                JvmTask myTask = umbilical.getTask(jvmId);
                if (myTask.shouldDie()) {
                    break;
                }
                if (myTask.getTask() == null) {
                    taskid = null;
                    if (++idleLoopCount >= 5) {
                        Thread.sleep(1500L);
                        continue;
                    }
                    Thread.sleep(500L);
                    continue;
                }
                idleLoopCount = 0;
                task = myTask.getTask();
                taskid = task.getTaskID();
                isCleanup = task.isTaskCleanupTask();
                FileSystem.clearStatistics();
                TaskLog.syncLogs(firstTaskid, taskid, isCleanup);
                JobConf job = new JobConf(task.getJobFile());
                if (job.getBoolean("task.memory.mgmt.enabled", false)) {
                    if (srcPidPath == null) {
                        srcPidPath = new Path(task.getPidFile());
                    }
                    if (!taskid.equals(firstTaskid)) {
                        dstPidPath = new Path(task.getPidFile());
                        FileUtil.symLink(srcPidPath.toUri().getPath(), dstPidPath.toUri().getPath());
                    }
                }
                TaskRunner.setupWorkDir(job);
                numTasksToExecute = job.getNumTasksToExecutePerJvm();
                assert (numTasksToExecute != 0);
                TaskLog.cleanup(job.getInt("mapred.userlog.retain.hours", 24));
                task.setConf(job);
                defaultConf.addResource(new Path(task.getJobFile()));
                JvmMetrics.init(task.getPhase().toString(), job.getSessionId());
                FileSystem.get(job).setWorkingDirectory(job.getWorkingDirectory());
                try {
                    task.run(job, umbilical);
                }
                finally {
                    TaskLog.syncLogs(firstTaskid, taskid, isCleanup);
                    if (!taskid.equals(firstTaskid) && job.getBoolean("task.memory.mgmt.enabled", false)) {
                        new File(dstPidPath.toUri().getPath()).delete();
                    }
                }
                if (numTasksToExecute > 0 && ++numTasksExecuted == numTasksToExecute) break;
            }
        }
        catch (FSError e) {
            LOG.fatal("FSError from child", e);
            umbilical.fsError(taskid, e.getMessage());
        }
        catch (Exception exception) {
            LOG.warn("Error running child", exception);
            try {
                if (task != null) {
                    task.taskCleanup(umbilical);
                }
            }
            catch (Exception e) {
                LOG.info("Error cleaning up" + e);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            exception.printStackTrace(new PrintStream(baos));
            if (taskid != null) {
                umbilical.reportDiagnosticInfo(taskid, baos.toString());
            }
        }
        catch (Throwable throwable) {
            LOG.fatal("Error running child : " + StringUtils.stringifyException(throwable));
            if (taskid != null) {
                Throwable tCause = throwable.getCause();
                String cause = tCause == null ? throwable.getMessage() : StringUtils.stringifyException(tCause);
                umbilical.fatalError(taskid, cause);
            }
        }
        finally {
            RPC.stopProxy(umbilical);
            MetricsContext metricsContext = MetricsUtil.getContext("mapred");
            metricsContext.close();
            LogManager.shutdown();
        }
    }
}

