/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.ipc;

import java.io.IOException;
import java.lang.reflect.Constructor;
import org.xml.sax.Attributes;
import org.znerd.xmlenc.XMLOutputter;

public class RemoteException
extends IOException {
    private static final long serialVersionUID = 1L;
    private String className;

    public RemoteException(String className, String msg) {
        super(msg);
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public IOException unwrapRemoteException(Class<?> ... lookupTypes) {
        if (lookupTypes == null) {
            return this;
        }
        for (Class<?> lookupClass : lookupTypes) {
            if (!lookupClass.getName().equals(this.getClassName())) continue;
            try {
                return this.instantiateException(lookupClass.asSubclass(IOException.class));
            }
            catch (Exception e) {
                return this;
            }
        }
        return this;
    }

    public IOException unwrapRemoteException() {
        try {
            Class<?> realClass = Class.forName(this.getClassName());
            return this.instantiateException(realClass.asSubclass(IOException.class));
        }
        catch (Exception exception) {
            return this;
        }
    }

    private IOException instantiateException(Class<? extends IOException> cls) throws Exception {
        Constructor<? extends IOException> cn = cls.getConstructor(String.class);
        cn.setAccessible(true);
        String firstLine = this.getMessage();
        int eol = firstLine.indexOf(10);
        if (eol >= 0) {
            firstLine = firstLine.substring(0, eol);
        }
        IOException ex = cn.newInstance(firstLine);
        ex.initCause(this);
        return ex;
    }

    public void writeXml(String path, XMLOutputter doc) throws IOException {
        doc.startTag(RemoteException.class.getSimpleName());
        doc.attribute("path", path);
        doc.attribute("class", this.getClassName());
        String msg = this.getLocalizedMessage();
        int i = msg.indexOf("\n");
        if (i >= 0) {
            msg = msg.substring(0, i);
        }
        doc.attribute("message", msg.substring(msg.indexOf(":") + 1).trim());
        doc.endTag();
    }

    public static RemoteException valueOf(Attributes attrs) {
        return new RemoteException(attrs.getValue("class"), attrs.getValue("message"));
    }
}

