/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.ipc;

import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.Text;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.security.UnixUserGroupInformation;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.security.UserGroupInformation;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

class ConnectionHeader
implements Writable {
    public static final Log LOG = LogFactory.getLog(ConnectionHeader.class);
    private String protocol;
    private UserGroupInformation ugi = new UnixUserGroupInformation();

    public ConnectionHeader() {
    }

    public ConnectionHeader(String protocol, UserGroupInformation ugi) {
        this.protocol = protocol;
        this.ugi = ugi;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        boolean ugiPresent;
        this.protocol = Text.readString(in);
        if (this.protocol.isEmpty()) {
            this.protocol = null;
        }
        if (ugiPresent = in.readBoolean()) {
            this.ugi.readFields(in);
        } else {
            this.ugi = null;
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString(out, this.protocol == null ? "" : this.protocol);
        if (this.ugi != null) {
            out.writeBoolean(true);
            this.ugi.write(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public UserGroupInformation getUgi() {
        return this.ugi;
    }

    public String toString() {
        return this.protocol + "-" + this.ugi;
    }
}

