/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.compress;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.compress.CompressionInputStream;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.compress.CompressionOutputStream;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.compress.Compressor;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.compress.CompressorStream;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.compress.Decompressor;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.compress.DecompressorStream;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.compress.DefaultCodec;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.compress.zlib.ZlibCompressor;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.compress.zlib.ZlibDecompressor;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.compress.zlib.ZlibFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzipCodec
extends DefaultCodec {
    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return ZlibFactory.isNativeZlibLoaded(this.conf) ? new CompressorStream(out, this.createCompressor(), this.conf.getInt("io.file.buffer.size", 4096)) : new GzipOutputStream(out);
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        return compressor != null ? new CompressorStream(out, compressor, this.conf.getInt("io.file.buffer.size", 4096)) : this.createOutputStream(out);
    }

    @Override
    public Compressor createCompressor() {
        return ZlibFactory.isNativeZlibLoaded(this.conf) ? new GzipZlibCompressor() : null;
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        return ZlibFactory.isNativeZlibLoaded(this.conf) ? GzipZlibCompressor.class : null;
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return ZlibFactory.isNativeZlibLoaded(this.conf) ? new DecompressorStream(in, this.createDecompressor(), this.conf.getInt("io.file.buffer.size", 4096)) : new GzipInputStream(in);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        return decompressor != null ? new DecompressorStream(in, decompressor, this.conf.getInt("io.file.buffer.size", 4096)) : this.createInputStream(in);
    }

    @Override
    public Decompressor createDecompressor() {
        return ZlibFactory.isNativeZlibLoaded(this.conf) ? new GzipZlibDecompressor() : null;
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        return ZlibFactory.isNativeZlibLoaded(this.conf) ? GzipZlibDecompressor.class : null;
    }

    @Override
    public String getDefaultExtension() {
        return ".gz";
    }

    static final class GzipZlibDecompressor
    extends ZlibDecompressor {
        public GzipZlibDecompressor() {
            super(ZlibDecompressor.CompressionHeader.AUTODETECT_GZIP_ZLIB, 65536);
        }
    }

    static final class GzipZlibCompressor
    extends ZlibCompressor {
        public GzipZlibCompressor() {
            super(ZlibCompressor.CompressionLevel.DEFAULT_COMPRESSION, ZlibCompressor.CompressionStrategy.DEFAULT_STRATEGY, ZlibCompressor.CompressionHeader.GZIP_FORMAT, 65536);
        }
    }

    protected static class GzipInputStream
    extends DecompressorStream {
        public GzipInputStream(InputStream in) throws IOException {
            super(new ResetableGZIPInputStream(in));
        }

        protected GzipInputStream(DecompressorStream in) {
            super(in);
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }

        @Override
        public int read(byte[] data, int offset, int len) throws IOException {
            return this.in.read(data, offset, len);
        }

        @Override
        public long skip(long offset) throws IOException {
            return this.in.skip(offset);
        }

        @Override
        public void resetState() throws IOException {
            ((ResetableGZIPInputStream)this.in).resetState();
        }

        private static class ResetableGZIPInputStream
        extends GZIPInputStream {
            public ResetableGZIPInputStream(InputStream in) throws IOException {
                super(in);
            }

            public void resetState() throws IOException {
                this.inf.reset();
            }
        }
    }

    protected static class GzipOutputStream
    extends CompressorStream {
        public GzipOutputStream(OutputStream out) throws IOException {
            super(new ResetableGZIPOutputStream(out));
        }

        protected GzipOutputStream(CompressorStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] data, int offset, int length) throws IOException {
            this.out.write(data, offset, length);
        }

        @Override
        public void finish() throws IOException {
            ((ResetableGZIPOutputStream)this.out).finish();
        }

        @Override
        public void resetState() throws IOException {
            ((ResetableGZIPOutputStream)this.out).resetState();
        }

        private static class ResetableGZIPOutputStream
        extends GZIPOutputStream {
            public ResetableGZIPOutputStream(OutputStream out) throws IOException {
                super(out);
            }

            public void resetState() throws IOException {
                this.def.reset();
            }
        }
    }
}

