/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.compress;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.compress.CompressionOutputStream;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.compress.Compressor;
import java.io.IOException;
import java.io.OutputStream;

public class CompressorStream
extends CompressionOutputStream {
    protected Compressor compressor;
    protected byte[] buffer;
    protected boolean closed = false;
    private byte[] oneByte = new byte[1];

    public CompressorStream(OutputStream out, Compressor compressor, int bufferSize) {
        super(out);
        if (out == null || compressor == null) {
            throw new NullPointerException();
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Illegal bufferSize");
        }
        this.compressor = compressor;
        this.buffer = new byte[bufferSize];
    }

    public CompressorStream(OutputStream out, Compressor compressor) {
        this(out, compressor, 512);
    }

    protected CompressorStream(OutputStream out) {
        super(out);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.compressor.finished()) {
            throw new IOException("write beyond end of stream");
        }
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.compressor.setInput(b, off, len);
        while (!this.compressor.needsInput()) {
            this.compress();
        }
    }

    protected void compress() throws IOException {
        int len = this.compressor.compress(this.buffer, 0, this.buffer.length);
        if (len > 0) {
            this.out.write(this.buffer, 0, len);
        }
    }

    @Override
    public void finish() throws IOException {
        if (!this.compressor.finished()) {
            this.compressor.finish();
            while (!this.compressor.finished()) {
                this.compress();
            }
        }
    }

    @Override
    public void resetState() throws IOException {
        this.compressor.reset();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.finish();
            this.out.close();
            this.closed = true;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.oneByte[0] = (byte)(b & 0xFF);
        this.write(this.oneByte, 0, this.oneByte.length);
    }
}

