/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hive.thrift;

import io.prestosql.hive.jdbc.;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hive.thrift.DelegationTokenIdentifier;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hive.thrift.DelegationTokenStore;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hive.thrift.TokenStoreDelegationTokenSecretManager;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.security.token.delegation.HiveDelegationTokenSupport;
import io.prestosql.hive.jdbc.$internal.org.slf4j.Logger;
import io.prestosql.hive.jdbc.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;

public class ZooKeeperTokenStore
implements DelegationTokenStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperTokenStore.class.getName());
    protected static final String ZK_SEQ_FORMAT = "%010d";
    private static final String NODE_KEYS = "/keys";
    private static final String NODE_TOKENS = "/tokens";
    private String rootNode = "";
    private volatile ZooKeeper zkSession;
    private String zkConnectString;
    private final int zkSessionTimeout = 3000;
    private long connectTimeoutMillis = -1L;
    private List<ACL> newNodeAcl = ZooDefs.Ids.OPEN_ACL_UNSAFE;

    protected ZooKeeperTokenStore() {
    }

    public ZooKeeperTokenStore(String hostPort) {
        this.zkConnectString = hostPort;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZooKeeper getSession() {
        if (this.zkSession == null || this.zkSession.getState() == ZooKeeper.States.CLOSED) {
            ZooKeeperTokenStore zooKeeperTokenStore = this;
            synchronized (zooKeeperTokenStore) {
                if (this.zkSession == null || this.zkSession.getState() == ZooKeeper.States.CLOSED) {
                    try {
                        this.zkSession = ZooKeeperTokenStore.createConnectedClient(this.zkConnectString, this.zkSessionTimeout, this.connectTimeoutMillis, new ZooKeeperWatcher());
                    }
                    catch (IOException ex) {
                        throw new DelegationTokenStore.TokenStoreException("Token store error.", ex);
                    }
                }
            }
        }
        return this.zkSession;
    }

    public static ZooKeeper createConnectedClient(String connectString, int sessionTimeout, long connectTimeout, final Watcher ... watchers) throws IOException {
        final CountDownLatch connected = new CountDownLatch(1);
        Watcher connectWatcher = new Watcher(){

            public void process(WatchedEvent event) {
                switch (event.getState()) {
                    case SyncConnected: {
                        connected.countDown();
                    }
                }
                for (Watcher w : watchers) {
                    w.process(event);
                }
            }
        };
        ZooKeeper zk = new ZooKeeper(connectString, sessionTimeout, connectWatcher);
        if (connectTimeout > 0L) {
            try {
                if (!connected.await(connectTimeout, TimeUnit.MILLISECONDS)) {
                    zk.close();
                    throw new IOException("Timeout waiting for connection after " + connectTimeout + "ms");
                }
            }
            catch (InterruptedException e) {
                throw new IOException("Error waiting for connection.", e);
            }
        }
        return zk;
    }

    public static String ensurePath(ZooKeeper zk, String path, List<ACL> acl) throws KeeperException, InterruptedException {
        String[] pathComps = .StringUtils.splitByWholeSeparator((String)path, (String)"/");
        String currentPath = "";
        for (String pathComp : pathComps) {
            currentPath = currentPath + "/" + pathComp;
            try {
                String node = zk.create(currentPath, new byte[0], acl, CreateMode.PERSISTENT);
                LOGGER.info("Created path: " + node);
            }
            catch (KeeperException.NodeExistsException e) {
                // empty catch block
            }
        }
        return currentPath;
    }

    public static int getPermFromString(String permString) {
        int perm = 0;
        block7: for (int i = 0; i < permString.length(); ++i) {
            switch (permString.charAt(i)) {
                case 'r': {
                    perm |= 1;
                    continue block7;
                }
                case 'w': {
                    perm |= 2;
                    continue block7;
                }
                case 'c': {
                    perm |= 4;
                    continue block7;
                }
                case 'd': {
                    perm |= 8;
                    continue block7;
                }
                case 'a': {
                    perm |= 0x10;
                    continue block7;
                }
                default: {
                    LOGGER.error("Unknown perm type: " + permString.charAt(i));
                }
            }
        }
        return perm;
    }

    public static List<ACL> parseACLs(String aclString) {
        String[] aclComps = .StringUtils.splitByWholeSeparator((String)aclString, (String)",");
        ArrayList<ACL> acl = new ArrayList<ACL>(aclComps.length);
        for (String a : aclComps) {
            if (.StringUtils.isBlank((String)a)) continue;
            a = a.trim();
            int firstColon = a.indexOf(58);
            int lastColon = a.lastIndexOf(58);
            if (firstColon == -1 || lastColon == -1 || firstColon == lastColon) {
                LOGGER.error(a + " does not have the form scheme:id:perm");
                continue;
            }
            ACL newAcl = new ACL();
            newAcl.setId(new Id(a.substring(0, firstColon), a.substring(firstColon + 1, lastColon)));
            newAcl.setPerms(ZooKeeperTokenStore.getPermFromString(a.substring(lastColon + 1)));
            acl.add(newAcl);
        }
        return acl;
    }

    private void init() {
        if (this.zkConnectString == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.zkSession != null) {
            try {
                this.zkSession.close();
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Failed to close existing session.", ex);
            }
        }
        ZooKeeper zk = this.getSession();
        try {
            ZooKeeperTokenStore.ensurePath(zk, this.rootNode + NODE_KEYS, this.newNodeAcl);
            ZooKeeperTokenStore.ensurePath(zk, this.rootNode + NODE_TOKENS, this.newNodeAcl);
        }
        catch (Exception e) {
            throw new DelegationTokenStore.TokenStoreException("Failed to validate token path.", e);
        }
    }

    @Override
    public void setConf(Configuration conf) {
        if (conf == null) {
            throw new IllegalArgumentException("conf is null");
        }
        this.zkConnectString = conf.get("hive.cluster.delegation.token.store.zookeeper.connectString", null);
        this.connectTimeoutMillis = conf.getLong("hive.cluster.delegation.token.store.zookeeper.connectTimeoutMillis", -1L);
        this.rootNode = conf.get("hive.cluster.delegation.token.store.zookeeper.znode", "/hive/cluster/delegation");
        String csv = conf.get("hive.cluster.delegation.token.store.zookeeper.acl", null);
        if (.StringUtils.isNotBlank((String)csv)) {
            this.newNodeAcl = ZooKeeperTokenStore.parseACLs(csv);
        }
        this.init();
    }

    @Override
    public Configuration getConf() {
        return null;
    }

    private Map<Integer, byte[]> getAllKeys() throws KeeperException, InterruptedException {
        String masterKeyNode = this.rootNode + NODE_KEYS;
        ZooKeeper zk = this.getSession();
        List nodes = zk.getChildren(masterKeyNode, false);
        HashMap<Integer, byte[]> result = new HashMap<Integer, byte[]>();
        for (String node : nodes) {
            byte[] data = zk.getData(masterKeyNode + "/" + node, false, null);
            if (data == null) continue;
            result.put(this.getSeq(node), data);
        }
        return result;
    }

    private int getSeq(String path) {
        String[] pathComps = path.split("/");
        return Integer.parseInt(pathComps[pathComps.length - 1]);
    }

    @Override
    public int addMasterKey(String s) {
        try {
            ZooKeeper zk = this.getSession();
            String newNode = zk.create(this.rootNode + NODE_KEYS + "/", s.getBytes(), this.newNodeAcl, CreateMode.PERSISTENT_SEQUENTIAL);
            LOGGER.info("Added key {}", (Object)newNode);
            return this.getSeq(newNode);
        }
        catch (KeeperException ex) {
            throw new DelegationTokenStore.TokenStoreException(ex);
        }
        catch (InterruptedException ex) {
            throw new DelegationTokenStore.TokenStoreException(ex);
        }
    }

    @Override
    public void updateMasterKey(int keySeq, String s) {
        try {
            ZooKeeper zk = this.getSession();
            zk.setData(this.rootNode + NODE_KEYS + "/" + String.format(ZK_SEQ_FORMAT, keySeq), s.getBytes(), -1);
        }
        catch (KeeperException ex) {
            throw new DelegationTokenStore.TokenStoreException(ex);
        }
        catch (InterruptedException ex) {
            throw new DelegationTokenStore.TokenStoreException(ex);
        }
    }

    @Override
    public boolean removeMasterKey(int keySeq) {
        try {
            ZooKeeper zk = this.getSession();
            zk.delete(this.rootNode + NODE_KEYS + "/" + String.format(ZK_SEQ_FORMAT, keySeq), -1);
            return true;
        }
        catch (KeeperException.NoNodeException ex) {
            return false;
        }
        catch (KeeperException ex) {
            throw new DelegationTokenStore.TokenStoreException(ex);
        }
        catch (InterruptedException ex) {
            throw new DelegationTokenStore.TokenStoreException(ex);
        }
    }

    @Override
    public String[] getMasterKeys() {
        try {
            Map<Integer, byte[]> allKeys = this.getAllKeys();
            String[] result = new String[allKeys.size()];
            int resultIdx = 0;
            for (byte[] keyBytes : allKeys.values()) {
                result[resultIdx++] = new String(keyBytes);
            }
            return result;
        }
        catch (KeeperException ex) {
            throw new DelegationTokenStore.TokenStoreException(ex);
        }
        catch (InterruptedException ex) {
            throw new DelegationTokenStore.TokenStoreException(ex);
        }
    }

    private String getTokenPath(DelegationTokenIdentifier tokenIdentifier) {
        try {
            return this.rootNode + NODE_TOKENS + "/" + TokenStoreDelegationTokenSecretManager.encodeWritable((Writable)((Object)tokenIdentifier));
        }
        catch (IOException ex) {
            throw new DelegationTokenStore.TokenStoreException("Failed to encode token identifier", ex);
        }
    }

    @Override
    public boolean addToken(DelegationTokenIdentifier tokenIdentifier, .AbstractDelegationTokenSecretManager.DelegationTokenInformation token) {
        try {
            ZooKeeper zk = this.getSession();
            byte[] tokenBytes = HiveDelegationTokenSupport.encodeDelegationTokenInformation(token);
            String newNode = zk.create(this.getTokenPath(tokenIdentifier), tokenBytes, this.newNodeAcl, CreateMode.PERSISTENT);
            LOGGER.info("Added token: {}", (Object)newNode);
            return true;
        }
        catch (KeeperException.NodeExistsException ex) {
            return false;
        }
        catch (KeeperException ex) {
            throw new DelegationTokenStore.TokenStoreException(ex);
        }
        catch (InterruptedException ex) {
            throw new DelegationTokenStore.TokenStoreException(ex);
        }
    }

    @Override
    public boolean removeToken(DelegationTokenIdentifier tokenIdentifier) {
        try {
            ZooKeeper zk = this.getSession();
            zk.delete(this.getTokenPath(tokenIdentifier), -1);
            return true;
        }
        catch (KeeperException.NoNodeException ex) {
            return false;
        }
        catch (KeeperException ex) {
            throw new DelegationTokenStore.TokenStoreException(ex);
        }
        catch (InterruptedException ex) {
            throw new DelegationTokenStore.TokenStoreException(ex);
        }
    }

    @Override
    public .AbstractDelegationTokenSecretManager.DelegationTokenInformation getToken(DelegationTokenIdentifier tokenIdentifier) {
        try {
            ZooKeeper zk = this.getSession();
            byte[] tokenBytes = zk.getData(this.getTokenPath(tokenIdentifier), false, null);
            try {
                return HiveDelegationTokenSupport.decodeDelegationTokenInformation(tokenBytes);
            }
            catch (Exception ex) {
                throw new DelegationTokenStore.TokenStoreException("Failed to decode token", ex);
            }
        }
        catch (KeeperException.NoNodeException ex) {
            return null;
        }
        catch (KeeperException ex) {
            throw new DelegationTokenStore.TokenStoreException(ex);
        }
        catch (InterruptedException ex) {
            throw new DelegationTokenStore.TokenStoreException(ex);
        }
    }

    @Override
    public List<DelegationTokenIdentifier> getAllDelegationTokenIdentifiers() {
        List nodes;
        String containerNode = this.rootNode + NODE_TOKENS;
        try {
            nodes = this.getSession().getChildren(containerNode, false);
        }
        catch (KeeperException ex) {
            throw new DelegationTokenStore.TokenStoreException(ex);
        }
        catch (InterruptedException ex) {
            throw new DelegationTokenStore.TokenStoreException(ex);
        }
        ArrayList<DelegationTokenIdentifier> result = new ArrayList<DelegationTokenIdentifier>(nodes.size());
        for (String node : nodes) {
            DelegationTokenIdentifier id = new DelegationTokenIdentifier();
            try {
                TokenStoreDelegationTokenSecretManager.decodeWritable((Writable)((Object)id), node);
                result.add(id);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to decode token '{}'", (Object)node);
            }
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        if (this.zkSession != null) {
            try {
                this.zkSession.close();
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Failed to close existing session.", ex);
            }
        }
    }

    @Override
    public void setStore(Object hmsHandler) throws DelegationTokenStore.TokenStoreException {
    }

    private class ZooKeeperWatcher
    implements Watcher {
        private ZooKeeperWatcher() {
        }

        public void process(WatchedEvent event) {
            LOGGER.info(event.toString());
            if (event.getState() == Watcher.Event.KeeperState.Expired) {
                LOGGER.warn("ZooKeeper session expired, discarding connection");
                try {
                    ZooKeeperTokenStore.this.zkSession.close();
                }
                catch (Throwable e) {
                    LOGGER.warn("Failed to close connection on expired session", e);
                }
            }
        }
    }
}

