/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hive.shims;

import io.prestosql.hive.jdbc.;
import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileSystem;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.PathFilter;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hive.io.HiveIOExceptionHandlerUtil;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hive.shims.CombineHiveKey;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hive.shims.HadoopShims;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hive.shims.ShimLoader;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hive.thrift.DelegationTokenSelector;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.Text;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.ClusterStatus;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.FileInputFormat;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.InputSplit;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.JobConf;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.OutputCommitter;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.RecordReader;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.Reporter;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.lib.CombineFileInputFormat;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.mapred.lib.CombineFileSplit;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.security.SecurityUtil;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.security.UserGroupInformation;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.Progressable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.ToolRunner;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public abstract class HadoopShimsSecure
implements HadoopShims {
    static final Log LOG = LogFactory.getLog(HadoopShimsSecure.class);
    String[] ret = new String[2];

    @Override
    public String unquoteHtmlChars(String item) {
        return .HtmlQuoting.unquoteHtmlChars((String)item);
    }

    @Override
    public HadoopShims.CombineFileInputFormatShim getCombineFileInputFormat() {
        return new CombineFileInputFormatShim(){

            @Override
            public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
                throw new IOException("CombineFileInputFormat.getRecordReader not needed.");
            }
        };
    }

    @Override
    public String getInputFormatClassName() {
        return "io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hive.ql.io.CombineHiveInputFormat";
    }

    @Override
    public int createHadoopArchive(Configuration conf, Path sourceDir, Path destDir, String archiveName) throws Exception {
        .HadoopArchives har = new .HadoopArchives(conf);
        ArrayList<String> args = new ArrayList<String>();
        args.add("-archiveName");
        args.add(archiveName);
        args.add("-p");
        args.add(sourceDir.toString());
        args.add(destDir.toString());
        return ToolRunner.run((.Tool)har, args.toArray(new String[0]));
    }

    @Override
    public URI getHarUri(URI original, URI base, URI originalBase) throws URISyntaxException {
        URI relative = originalBase.relativize(original);
        if (relative.isAbsolute()) {
            throw new URISyntaxException("Couldn't create URI for location.", "Relative: " + relative + " Base: " + base + " OriginalBase: " + originalBase);
        }
        return base.resolve(relative);
    }

    @Override
    public void prepareJobOutput(JobConf conf) {
        conf.setOutputCommitter(NullOutputCommitter.class);
        conf.setBoolean(ShimLoader.getHadoopShims().getHadoopConfNames().get("MAPREDSETUPCLEANUPNEEDED"), false);
        conf.setBoolean(ShimLoader.getHadoopShims().getHadoopConfNames().get("MAPREDTASKCLEANUPNEEDED"), false);
    }

    @Override
    public UserGroupInformation getUGIForConf(Configuration conf) throws IOException {
        return UserGroupInformation.getCurrentUser();
    }

    @Override
    public boolean isSecureShimImpl() {
        return true;
    }

    @Override
    public String getShortUserName(UserGroupInformation ugi) {
        return ugi.getShortUserName();
    }

    @Override
    public String getTokenStrForm(String tokenSignature) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        DelegationTokenSelector tokenSelector = new DelegationTokenSelector();
        .Token token = tokenSelector.selectToken(tokenSignature == null ? new Text() : new Text(tokenSignature), ugi.getTokens());
        return token != null ? token.encodeToUrlString() : null;
    }

    @Override
    public void setTokenStr(UserGroupInformation ugi, String tokenStr, String tokenService) throws IOException {
        .Token<.DelegationTokenIdentifier> delegationToken = this.createToken(tokenStr, tokenService);
        ugi.addToken(delegationToken);
    }

    @Override
    public String addServiceToToken(String tokenStr, String tokenService) throws IOException {
        .Token<.DelegationTokenIdentifier> delegationToken = this.createToken(tokenStr, tokenService);
        return delegationToken.encodeToUrlString();
    }

    private .Token<.DelegationTokenIdentifier> createToken(String tokenStr, String tokenService) throws IOException {
        .Token delegationToken = new .Token();
        delegationToken.decodeFromUrlString(tokenStr);
        delegationToken.setService(new Text(tokenService));
        return delegationToken;
    }

    @Override
    public <T> T doAs(UserGroupInformation ugi, PrivilegedExceptionAction<T> pvea) throws IOException, InterruptedException {
        return (T)ugi.doAs(pvea);
    }

    @Override
    public Path createDelegationTokenFile(Configuration conf) throws IOException {
        String uname = UserGroupInformation.getLoginUser().getShortUserName();
        FileSystem fs = FileSystem.get(conf);
        .Token fsToken = fs.getDelegationToken(uname);
        File t = File.createTempFile("hive_hadoop_delegation_token", null);
        Path tokenPath = new Path(t.toURI());
        .Credentials cred = new .Credentials();
        cred.addToken(fsToken.getService(), fsToken);
        cred.writeTokenStorageFile(tokenPath, conf);
        return tokenPath;
    }

    @Override
    public UserGroupInformation createProxyUser(String userName) throws IOException {
        return UserGroupInformation.createProxyUser((String)userName, (UserGroupInformation)UserGroupInformation.getLoginUser());
    }

    @Override
    public void authorizeProxyAccess(String proxyUser, UserGroupInformation realUserUgi, String ipAddress, Configuration conf) throws IOException {
        .ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        .ProxyUsers.authorize((UserGroupInformation)UserGroupInformation.createProxyUser((String)proxyUser, (UserGroupInformation)realUserUgi), (String)ipAddress, (Configuration)conf);
    }

    @Override
    public boolean isSecurityEnabled() {
        return UserGroupInformation.isSecurityEnabled();
    }

    @Override
    public UserGroupInformation createRemoteUser(String userName, List<String> groupNames) {
        return UserGroupInformation.createRemoteUser((String)userName);
    }

    @Override
    public void closeAllForUGI(UserGroupInformation ugi) {
        try {
            FileSystem.closeAllForUGI((UserGroupInformation)ugi);
        }
        catch (IOException e) {
            LOG.error("Could not clean up file-system handles for UGI: " + ugi, e);
        }
    }

    @Override
    public void loginUserFromKeytab(String principal, String keytabFile) throws IOException {
        String hostPrincipal = SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0");
        UserGroupInformation.loginUserFromKeytab((String)hostPrincipal, (String)keytabFile);
    }

    @Override
    public UserGroupInformation loginUserFromKeytabAndReturnUGI(String principal, String keytabFile) throws IOException {
        String hostPrincipal = SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0");
        return UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)hostPrincipal, (String)keytabFile);
    }

    @Override
    public String getTokenFileLocEnvName() {
        return "HADOOP_TOKEN_FILE_LOCATION";
    }

    @Override
    public void reLoginUserFromKeytab() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        if (ugi.isFromKeytab()) {
            ugi.checkTGTAndReloginFromKeytab();
        }
    }

    @Override
    public boolean isLoginKeytabBased() throws IOException {
        return UserGroupInformation.isLoginKeytabBased();
    }

    @Override
    public abstract HadoopShims.JobTrackerState getJobTrackerState(ClusterStatus var1) throws Exception;

    @Override
    public abstract .TaskAttemptContext newTaskAttemptContext(Configuration var1, Progressable var2);

    @Override
    public abstract .JobContext newJobContext(.Job var1);

    @Override
    public abstract boolean isLocalMode(Configuration var1);

    @Override
    public abstract void setJobLauncherRpcAddress(Configuration var1, String var2);

    @Override
    public abstract String getJobLauncherHttpAddress(Configuration var1);

    @Override
    public abstract String getJobLauncherRpcAddress(Configuration var1);

    @Override
    public abstract short getDefaultReplication(FileSystem var1, Path var2);

    @Override
    public abstract long getDefaultBlockSize(FileSystem var1, Path var2);

    @Override
    public abstract boolean moveToAppropriateTrash(FileSystem var1, Path var2, Configuration var3) throws IOException;

    @Override
    public abstract FileSystem createProxyFileSystem(FileSystem var1, URI var2);

    @Override
    public abstract FileSystem getNonCachedFileSystem(URI var1, Configuration var2) throws IOException;

    public static class NullOutputCommitter
    extends OutputCommitter {
        @Override
        public void setupJob(.JobContext jobContext) {
        }

        @Override
        public void cleanupJob(.JobContext jobContext) {
        }

        @Override
        public void setupTask(.TaskAttemptContext taskContext) {
        }

        @Override
        public boolean needsTaskCommit(.TaskAttemptContext taskContext) {
            return false;
        }

        @Override
        public void commitTask(.TaskAttemptContext taskContext) {
        }

        @Override
        public void abortTask(.TaskAttemptContext taskContext) {
        }
    }

    public static abstract class CombineFileInputFormatShim<K, V>
    extends CombineFileInputFormat<K, V>
    implements HadoopShims.CombineFileInputFormatShim<K, V> {
        @Override
        public Path[] getInputPathsShim(JobConf conf) {
            try {
                return FileInputFormat.getInputPaths(conf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void createPool(JobConf conf, PathFilter ... filters) {
            super.createPool(conf, filters);
        }

        public InputSplitShim[] getSplits(JobConf job, int numSplits) throws IOException {
            long minSize = job.getLong(ShimLoader.getHadoopShims().getHadoopConfNames().get("MAPREDMINSPLITSIZE"), 0L);
            if (job.getLong(ShimLoader.getHadoopShims().getHadoopConfNames().get("MAPREDMINSPLITSIZEPERNODE"), 0L) == 0L) {
                super.setMinSplitSizeNode(minSize);
            }
            if (job.getLong(ShimLoader.getHadoopShims().getHadoopConfNames().get("MAPREDMINSPLITSIZEPERRACK"), 0L) == 0L) {
                super.setMinSplitSizeRack(minSize);
            }
            if (job.getLong(ShimLoader.getHadoopShims().getHadoopConfNames().get("MAPREDMAXSPLITSIZE"), 0L) == 0L) {
                super.setMaxSplitSize(minSize);
            }
            InputSplit[] splits = super.getSplits(job, numSplits);
            InputSplitShim[] isplits = new InputSplitShim[splits.length];
            for (int pos = 0; pos < splits.length; ++pos) {
                isplits[pos] = new InputSplitShim((CombineFileSplit)splits[pos]);
            }
            return isplits;
        }

        @Override
        public InputSplitShim getInputSplitShim() throws IOException {
            return new InputSplitShim();
        }

        @Override
        public RecordReader getRecordReader(JobConf job, HadoopShims.InputSplitShim split, Reporter reporter, Class<RecordReader<K, V>> rrClass) throws IOException {
            CombineFileSplit cfSplit = (CombineFileSplit)((Object)split);
            return new CombineFileRecordReader<K, V>(job, cfSplit, reporter, rrClass);
        }
    }

    public static class CombineFileRecordReader<K, V>
    implements RecordReader<K, V> {
        static final Class[] constructorSignature = new Class[]{InputSplit.class, Configuration.class, Reporter.class, Integer.class};
        protected CombineFileSplit split;
        protected JobConf jc;
        protected Reporter reporter;
        protected Class<RecordReader<K, V>> rrClass;
        protected Constructor<RecordReader<K, V>> rrConstructor;
        protected FileSystem fs;
        protected int idx;
        protected long progress;
        protected RecordReader<K, V> curReader;
        protected boolean isShrinked;
        protected long shrinkedLength;

        @Override
        public boolean next(K key, V value) throws IOException {
            while (this.curReader == null || !this.doNextWithExceptionHandler(((CombineHiveKey)key).getKey(), value)) {
                if (this.initNextRecordReader(key)) continue;
                return false;
            }
            return true;
        }

        @Override
        public K createKey() {
            K newKey = this.curReader.createKey();
            return (K)new CombineHiveKey(newKey);
        }

        @Override
        public V createValue() {
            return this.curReader.createValue();
        }

        @Override
        public long getPos() throws IOException {
            return this.progress;
        }

        @Override
        public void close() throws IOException {
            if (this.curReader != null) {
                this.curReader.close();
                this.curReader = null;
            }
        }

        @Override
        public float getProgress() throws IOException {
            return Math.min(1.0f, (float)this.progress / (float)this.split.getLength());
        }

        public CombineFileRecordReader(JobConf job, CombineFileSplit split, Reporter reporter, Class<RecordReader<K, V>> rrClass) throws IOException {
            this.split = split;
            this.jc = job;
            this.rrClass = rrClass;
            this.reporter = reporter;
            this.idx = 0;
            this.curReader = null;
            this.progress = 0L;
            this.isShrinked = false;
            assert (split instanceof InputSplitShim);
            if (((InputSplitShim)split).isShrinked()) {
                this.isShrinked = true;
                this.shrinkedLength = ((InputSplitShim)split).getShrinkedLength();
            }
            try {
                this.rrConstructor = rrClass.getDeclaredConstructor(constructorSignature);
                this.rrConstructor.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(rrClass.getName() + " does not have valid constructor", e);
            }
            this.initNextRecordReader(null);
        }

        private boolean doNextWithExceptionHandler(K key, V value) throws IOException {
            try {
                return this.curReader.next(key, value);
            }
            catch (Exception e) {
                return HiveIOExceptionHandlerUtil.handleRecordReaderNextException(e, this.jc);
            }
        }

        protected boolean initNextRecordReader(K key) throws IOException {
            if (this.curReader != null) {
                this.curReader.close();
                this.curReader = null;
                if (this.idx > 0) {
                    this.progress += this.split.getLength(this.idx - 1);
                }
            }
            if (this.idx == this.split.getNumPaths() || this.isShrinked && this.progress > this.shrinkedLength) {
                return false;
            }
            try {
                this.curReader = this.rrConstructor.newInstance(this.split, this.jc, this.reporter, this.idx);
                if (key != null) {
                    K newKey = this.curReader.createKey();
                    ((CombineHiveKey)key).setKey(newKey);
                }
                this.jc.set("map.input.file", this.split.getPath(this.idx).toString());
                this.jc.setLong("map.input.start", this.split.getOffset(this.idx));
                this.jc.setLong("map.input.length", this.split.getLength(this.idx));
            }
            catch (Exception e) {
                this.curReader = HiveIOExceptionHandlerUtil.handleRecordReaderCreationException(e, this.jc);
            }
            ++this.idx;
            return true;
        }
    }

    public static class InputSplitShim
    extends CombineFileSplit
    implements HadoopShims.InputSplitShim {
        long shrinkedLength;
        boolean _isShrinked = false;

        public InputSplitShim() {
        }

        public InputSplitShim(CombineFileSplit old) throws IOException {
            super(old.getJob(), old.getPaths(), old.getStartOffsets(), old.getLengths(), InputSplitShim.dedup(old.getLocations()));
        }

        private static String[] dedup(String[] locations) {
            HashSet dedup = new HashSet();
            Collections.addAll(dedup, locations);
            return dedup.toArray(new String[dedup.size()]);
        }

        @Override
        public void shrinkSplit(long length) {
            this._isShrinked = true;
            this.shrinkedLength = length;
        }

        public boolean isShrinked() {
            return this._isShrinked;
        }

        public long getShrinkedLength() {
            return this.shrinkedLength;
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            super.readFields(in);
            this._isShrinked = in.readBoolean();
            if (this._isShrinked) {
                this.shrinkedLength = in.readLong();
            }
        }

        @Override
        public void write(DataOutput out) throws IOException {
            super.write(out);
            out.writeBoolean(this._isShrinked);
            if (this._isShrinked) {
                out.writeLong(this.shrinkedLength);
            }
        }
    }
}

