/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hive.common.type;

import io.prestosql.hive.jdbc.;

public abstract class HiveBaseChar {
    protected String value;

    protected HiveBaseChar() {
    }

    public void setValue(String val, int maxLength) {
        this.value = HiveBaseChar.enforceMaxLength(val, maxLength);
    }

    public void setValue(HiveBaseChar val, int maxLength) {
        this.setValue(val.value, maxLength);
    }

    public static String enforceMaxLength(String val, int maxLength) {
        int valLength;
        String value = val;
        if (maxLength > 0 && (valLength = val.codePointCount(0, val.length())) > maxLength) {
            value = val.substring(0, val.offsetByCodePoints(0, maxLength));
        }
        return value;
    }

    public static String getPaddedValue(String val, int maxLength) {
        if (maxLength < 0) {
            return val;
        }
        int valLength = val.codePointCount(0, val.length());
        if (valLength > maxLength) {
            return HiveBaseChar.enforceMaxLength(val, maxLength);
        }
        if (maxLength > valLength) {
            int padLength = val.length() + (maxLength - valLength);
            val = .StringUtils.rightPad((String)val, (int)padLength);
        }
        return val;
    }

    public String getValue() {
        return this.value;
    }

    public int getCharacterLength() {
        return this.value.codePointCount(0, this.value.length());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public String toString() {
        return this.getValue();
    }
}

