/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hive.common.metrics;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hive.common.metrics.MetricsMBean;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hive.common.metrics.MetricsMBeanImpl;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class Metrics {
    private static final MetricsMBean metrics = new MetricsMBeanImpl();
    private static final ObjectName oname;
    private static final ThreadLocal<HashMap<String, MetricsScope>> threadLocalScopes;
    private static boolean initialized;

    private Metrics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() throws Exception {
        MetricsMBean metricsMBean = metrics;
        synchronized (metricsMBean) {
            if (!initialized) {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                mbs.registerMBean(metrics, oname);
                initialized = true;
            }
        }
    }

    public static Long incrementCounter(String name) throws IOException {
        if (!initialized) {
            return null;
        }
        return Metrics.incrementCounter(name, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long incrementCounter(String name, long increment) throws IOException {
        Long value;
        if (!initialized) {
            return null;
        }
        MetricsMBean metricsMBean = metrics;
        synchronized (metricsMBean) {
            if (!metrics.hasKey(name)) {
                value = increment;
                Metrics.set(name, value);
            } else {
                value = (Long)Metrics.get(name) + increment;
                Metrics.set(name, value);
            }
        }
        return value;
    }

    public static void set(String name, Object value) throws IOException {
        if (!initialized) {
            return;
        }
        metrics.put(name, value);
    }

    public static Object get(String name) throws IOException {
        if (!initialized) {
            return null;
        }
        return metrics.get(name);
    }

    public static MetricsScope startScope(String name) throws IOException {
        if (!initialized) {
            return null;
        }
        if (threadLocalScopes.get().containsKey(name)) {
            threadLocalScopes.get().get(name).open();
        } else {
            threadLocalScopes.get().put(name, new MetricsScope(name));
        }
        return threadLocalScopes.get().get(name);
    }

    public static MetricsScope getScope(String name) throws IOException {
        if (!initialized) {
            return null;
        }
        if (threadLocalScopes.get().containsKey(name)) {
            return threadLocalScopes.get().get(name);
        }
        throw new IOException("No metrics scope named " + name);
    }

    public static void endScope(String name) throws IOException {
        if (!initialized) {
            return;
        }
        if (threadLocalScopes.get().containsKey(name)) {
            threadLocalScopes.get().get(name).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void uninit() throws Exception {
        MetricsMBean metricsMBean = metrics;
        synchronized (metricsMBean) {
            if (initialized) {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                if (mbs.isRegistered(oname)) {
                    mbs.unregisterMBean(oname);
                }
                metrics.clear();
                initialized = false;
            }
        }
    }

    static {
        try {
            oname = new ObjectName("io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hive.common.metrics:type=MetricsMBean");
        }
        catch (MalformedObjectNameException mone) {
            throw new RuntimeException(mone);
        }
        threadLocalScopes = new ThreadLocal<HashMap<String, MetricsScope>>(){

            @Override
            protected HashMap<String, MetricsScope> initialValue() {
                return new HashMap<String, MetricsScope>();
            }
        };
        initialized = false;
    }

    public static class MetricsScope {
        final String name;
        final String numCounter;
        final String timeCounter;
        final String avgTimeCounter;
        private boolean isOpen = false;
        private Long startTime = null;

        private MetricsScope(String name) throws IOException {
            this.name = name;
            this.numCounter = name + ".n";
            this.timeCounter = name + ".t";
            this.avgTimeCounter = name + ".avg_t";
            this.open();
        }

        public Long getNumCounter() throws IOException {
            return (Long)Metrics.get(this.numCounter);
        }

        public Long getTimeCounter() throws IOException {
            return (Long)Metrics.get(this.timeCounter);
        }

        public void open() throws IOException {
            if (this.isOpen) {
                throw new IOException("Scope named " + this.name + " is not closed, cannot be opened.");
            }
            this.isOpen = true;
            this.startTime = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.isOpen) {
                Long endTime = System.currentTimeMillis();
                MetricsMBean metricsMBean = metrics;
                synchronized (metricsMBean) {
                    Long num = Metrics.incrementCounter(this.numCounter);
                    Long time = Metrics.incrementCounter(this.timeCounter, endTime - this.startTime);
                    if (num != null && time != null) {
                        Metrics.set(this.avgTimeCounter, time.doubleValue() / num.doubleValue());
                    }
                }
            } else {
                throw new IOException("Scope named " + this.name + " is not open, cannot be closed.");
            }
            this.isOpen = false;
        }

        public void reopen() throws IOException {
            if (this.isOpen) {
                this.close();
            }
            this.open();
        }
    }
}

