/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.protocol;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.common.Storage;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.common.StorageInfo;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.UTF8;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.WritableFactories;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.WritableFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class NamespaceInfo
extends StorageInfo
implements Writable {
    String buildVersion;
    int distributedUpgradeVersion;

    public NamespaceInfo() {
        this.buildVersion = null;
    }

    public NamespaceInfo(int nsID, long cT, int duVersion) {
        super(-18, nsID, cT);
        this.buildVersion = Storage.getBuildVersion();
        this.distributedUpgradeVersion = duVersion;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public int getDistributedUpgradeVersion() {
        return this.distributedUpgradeVersion;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        UTF8.writeString(out, this.getBuildVersion());
        out.writeInt(this.getLayoutVersion());
        out.writeInt(this.getNamespaceID());
        out.writeLong(this.getCTime());
        out.writeInt(this.getDistributedUpgradeVersion());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.buildVersion = UTF8.readString(in);
        this.layoutVersion = in.readInt();
        this.namespaceID = in.readInt();
        this.cTime = in.readLong();
        this.distributedUpgradeVersion = in.readInt();
    }

    static {
        WritableFactories.setFactory(NamespaceInfo.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new NamespaceInfo();
            }
        });
    }
}

