/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.protocol.FSConstants;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.common.HdfsConstants;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.common.UpgradeManager;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.common.UpgradeObjectCollection;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.common.UpgradeStatusReport;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.common.Upgradeable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.FSImage;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.NameNode;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.UpgradeObjectNamenode;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.protocol.UpgradeCommand;
import java.io.IOException;
import java.util.SortedSet;

class UpgradeManagerNamenode
extends UpgradeManager {
    UpgradeManagerNamenode() {
    }

    @Override
    public HdfsConstants.NodeType getType() {
        return HdfsConstants.NodeType.NAME_NODE;
    }

    @Override
    public synchronized boolean startUpgrade() throws IOException {
        if (!this.upgradeState) {
            this.initializeUpgrade();
            if (!this.upgradeState) {
                return false;
            }
            FSNamesystem.getFSNamesystem().getFSImage().writeAll();
        }
        assert (this.currentUpgrades != null) : "currentUpgrades is null";
        this.broadcastCommand = ((Upgradeable)this.currentUpgrades.first()).startUpgrade();
        NameNode.LOG.info("\n   Distributed upgrade for NameNode version " + this.getUpgradeVersion() + " to current LV " + -18 + " is started.");
        return true;
    }

    synchronized UpgradeCommand processUpgradeCommand(UpgradeCommand command) throws IOException {
        NameNode.LOG.debug("\n   Distributed upgrade for NameNode version " + this.getUpgradeVersion() + " to current LV " + -18 + " is processing upgrade command: " + command.getAction() + " status = " + this.getUpgradeStatus() + "%");
        if (this.currentUpgrades == null) {
            NameNode.LOG.info("Ignoring upgrade command: " + command.getAction() + " version " + command.getVersion() + ". No distributed upgrades are currently running on the NameNode");
            return null;
        }
        UpgradeObjectNamenode curUO = (UpgradeObjectNamenode)this.currentUpgrades.first();
        if (command.getVersion() != curUO.getVersion()) {
            throw new IncorrectVersionException(command.getVersion(), "UpgradeCommand", curUO.getVersion());
        }
        UpgradeCommand reply = curUO.processUpgradeCommand(command);
        if (curUO.getUpgradeStatus() < 100) {
            return reply;
        }
        curUO.completeUpgrade();
        NameNode.LOG.info("\n   Distributed upgrade for NameNode version " + curUO.getVersion() + " to current LV " + -18 + " is complete.");
        this.currentUpgrades.remove(curUO);
        if (this.currentUpgrades.isEmpty()) {
            this.completeUpgrade();
        } else {
            curUO = (UpgradeObjectNamenode)this.currentUpgrades.first();
            this.broadcastCommand = curUO.startUpgrade();
        }
        return reply;
    }

    @Override
    public synchronized void completeUpgrade() throws IOException {
        this.setUpgradeState(false, -18);
        FSNamesystem.getFSNamesystem().getFSImage().writeAll();
        this.currentUpgrades = null;
        this.broadcastCommand = null;
        FSNamesystem.getFSNamesystem().leaveSafeMode(false);
    }

    UpgradeStatusReport distributedUpgradeProgress(FSConstants.UpgradeAction action) throws IOException {
        boolean isFinalized = false;
        if (this.currentUpgrades == null) {
            FSImage fsimage = FSNamesystem.getFSNamesystem().getFSImage();
            isFinalized = fsimage.isUpgradeFinalized();
            if (isFinalized) {
                return null;
            }
            return new UpgradeStatusReport(fsimage.getLayoutVersion(), 101, isFinalized);
        }
        UpgradeObjectNamenode curUO = (UpgradeObjectNamenode)this.currentUpgrades.first();
        boolean details = false;
        switch (action) {
            case GET_STATUS: {
                break;
            }
            case DETAILED_STATUS: {
                details = true;
                break;
            }
            case FORCE_PROCEED: {
                curUO.forceProceed();
            }
        }
        return curUO.getUpgradeStatusReport(details);
    }

    public static void main(String[] args) throws IOException {
        UpgradeManagerNamenode um = new UpgradeManagerNamenode();
        SortedSet<Upgradeable> uos = UpgradeObjectCollection.getDistributedUpgrades(-4, HdfsConstants.NodeType.NAME_NODE);
        System.out.println(uos.size());
        um.startUpgrade();
    }
}

