/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode;

import java.util.HashMap;
import java.util.Map;

class SerialNumberManager {
    static final SerialNumberManager INSTANCE = new SerialNumberManager();
    private SerialNumberMap<String> usermap = new SerialNumberMap();
    private SerialNumberMap<String> groupmap = new SerialNumberMap();

    private SerialNumberManager() {
        this.getUserSerialNumber(null);
        this.getGroupSerialNumber(null);
    }

    int getUserSerialNumber(String u) {
        return this.usermap.get(u);
    }

    int getGroupSerialNumber(String g) {
        return this.groupmap.get(g);
    }

    String getUser(int n) {
        return this.usermap.get(n);
    }

    String getGroup(int n) {
        return this.groupmap.get(n);
    }

    private static class SerialNumberMap<T> {
        private int max = 0;
        private Map<T, Integer> t2i = new HashMap<T, Integer>();
        private Map<Integer, T> i2t = new HashMap<Integer, T>();

        private SerialNumberMap() {
        }

        private int nextSerialNumber() {
            return this.max++;
        }

        synchronized int get(T t) {
            Integer sn = this.t2i.get(t);
            if (sn == null) {
                sn = this.nextSerialNumber();
                this.t2i.put(t, sn);
                this.i2t.put(sn, t);
            }
            return sn;
        }

        synchronized T get(int i) {
            if (!this.i2t.containsKey(i)) {
                throw new IllegalStateException("!i2t.containsKey(" + i + "), this=" + this);
            }
            return this.i2t.get(i);
        }

        public String toString() {
            return "max=" + this.max + ",\n  t2i=" + this.t2i + ",\n  i2t=" + this.i2t;
        }
    }
}

