/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode;

import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.permission.FsAction;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.permission.FsPermission;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.INode;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.security.AccessControlException;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.security.UserGroupInformation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

class PermissionChecker {
    static final Log LOG = LogFactory.getLog(UserGroupInformation.class);
    final String user;
    private final Set<String> groups = new HashSet<String>();
    final boolean isSuper;

    PermissionChecker(String fsOwner, String supergroup) throws AccessControlException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUGI();
        if (LOG.isDebugEnabled()) {
            LOG.debug("ugi=" + ugi);
        }
        if (ugi == null) {
            throw new AccessControlException("ugi = null");
        }
        this.user = ugi.getUserName();
        this.groups.addAll(Arrays.asList(ugi.getGroupNames()));
        this.isSuper = this.user.equals(fsOwner) || this.groups.contains(supergroup);
    }

    boolean containsGroup(String group) {
        return this.groups.contains(group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPermission(String path, INodeDirectory root, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess) throws AccessControlException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ACCESS CHECK: " + this + ", doCheckOwner=" + doCheckOwner + ", ancestorAccess=" + (Object)((Object)ancestorAccess) + ", parentAccess=" + (Object)((Object)parentAccess) + ", access=" + (Object)((Object)access) + ", subAccess=" + (Object)((Object)subAccess));
        }
        INodeDirectory iNodeDirectory = root;
        synchronized (iNodeDirectory) {
            int ancestorIndex;
            INode[] inodes = root.getExistingPathINodes(path);
            for (ancestorIndex = inodes.length - 2; ancestorIndex >= 0 && inodes[ancestorIndex] == null; --ancestorIndex) {
            }
            this.checkTraverse(inodes, ancestorIndex);
            if (ancestorAccess != null && inodes.length > 1) {
                this.check(inodes, ancestorIndex, ancestorAccess);
            }
            if (parentAccess != null && inodes.length > 1) {
                this.check(inodes, inodes.length - 2, parentAccess);
            }
            if (access != null) {
                this.check(inodes[inodes.length - 1], access);
            }
            if (subAccess != null) {
                this.checkSubAccess(inodes[inodes.length - 1], subAccess);
            }
            if (doCheckOwner) {
                this.checkOwner(inodes[inodes.length - 1]);
            }
        }
    }

    private void checkOwner(INode inode) throws AccessControlException {
        if (inode != null && this.user.equals(inode.getUserName())) {
            return;
        }
        throw new AccessControlException("Permission denied");
    }

    private void checkTraverse(INode[] inodes, int last) throws AccessControlException {
        for (int j = 0; j <= last; ++j) {
            this.check(inodes[j], FsAction.EXECUTE);
        }
    }

    private void checkSubAccess(INode inode, FsAction access) throws AccessControlException {
        if (inode == null || !inode.isDirectory()) {
            return;
        }
        Stack<INodeDirectory> directories = new Stack<INodeDirectory>();
        directories.push((INodeDirectory)inode);
        while (!directories.isEmpty()) {
            INodeDirectory d = (INodeDirectory)directories.pop();
            this.check(d, access);
            for (INode child : d.getChildren()) {
                if (!child.isDirectory()) continue;
                directories.push((INodeDirectory)child);
            }
        }
    }

    private void check(INode[] inodes, int i, FsAction access) throws AccessControlException {
        this.check(i >= 0 ? inodes[i] : null, access);
    }

    private void check(INode inode, FsAction access) throws AccessControlException {
        if (inode == null) {
            return;
        }
        FsPermission mode = inode.getFsPermission();
        if (this.user.equals(inode.getUserName()) ? mode.getUserAction().implies(access) : (this.groups.contains(inode.getGroupName()) ? mode.getGroupAction().implies(access) : mode.getOtherAction().implies(access))) {
            return;
        }
        throw new AccessControlException("Permission denied: user=" + this.user + ", access=" + (Object)((Object)access) + ", inode=" + inode);
    }
}

