/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.permission.FsAction;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.permission.FsPermission;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.permission.PermissionStatus;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.protocol.Block;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.INode;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class INodeDirectory
extends INode {
    protected static final int DEFAULT_FILES_PER_DIRECTORY = 5;
    static final String ROOT_NAME = "";
    private List<INode> children;

    INodeDirectory(String name, PermissionStatus permissions) {
        super(name, permissions);
        this.children = null;
    }

    public INodeDirectory(PermissionStatus permissions, long mTime) {
        super(permissions, mTime, 0L);
        this.children = null;
    }

    INodeDirectory(byte[] localName, PermissionStatus permissions, long mTime) {
        this(permissions, mTime);
        this.name = localName;
    }

    INodeDirectory(INodeDirectory other) {
        super(other);
        this.children = other.getChildren();
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    INode removeChild(INode node) {
        assert (this.children != null);
        int low = Collections.binarySearch(this.children, node.name);
        if (low >= 0) {
            return this.children.remove(low);
        }
        return null;
    }

    void replaceChild(INode newChild) {
        if (this.children == null) {
            throw new IllegalArgumentException("The directory is empty");
        }
        int low = Collections.binarySearch(this.children, newChild.name);
        if (low < 0) {
            throw new IllegalArgumentException("No child exists to be replaced");
        }
        this.children.set(low, newChild);
    }

    INode getChild(String name) {
        return this.getChildINode(INodeDirectory.string2Bytes(name));
    }

    private INode getChildINode(byte[] name) {
        if (this.children == null) {
            return null;
        }
        int low = Collections.binarySearch(this.children, name);
        if (low >= 0) {
            return this.children.get(low);
        }
        return null;
    }

    private INode getNode(byte[][] components) {
        INode[] inode = new INode[1];
        this.getExistingPathINodes(components, inode);
        return inode[0];
    }

    INode getNode(String path) {
        return this.getNode(INodeDirectory.getPathComponents(path));
    }

    int getExistingPathINodes(byte[][] components, INode[] existing) {
        assert (INodeDirectory.compareBytes(this.name, components[0]) == 0) : "Incorrect name " + this.getLocalName() + " expected " + components[0];
        INode curNode = this;
        int count = 0;
        int index = existing.length - components.length;
        if (index > 0) {
            index = 0;
        }
        while (count < components.length && curNode != null) {
            if (index >= 0) {
                existing[index] = curNode;
            }
            if (!((INode)curNode).isDirectory() || count == components.length - 1) break;
            INodeDirectory parentDir = curNode;
            curNode = parentDir.getChildINode(components[count + 1]);
            ++count;
            ++index;
        }
        return count;
    }

    INode[] getExistingPathINodes(String path) {
        byte[][] components = INodeDirectory.getPathComponents(path);
        INode[] inodes = new INode[components.length];
        this.getExistingPathINodes(components, inodes);
        return inodes;
    }

    <T extends INode> T addChild(T node, boolean inheritPermission) {
        int low;
        if (inheritPermission) {
            FsPermission p = this.getFsPermission();
            if (!p.getUserAction().implies(FsAction.WRITE_EXECUTE)) {
                p = new FsPermission(p.getUserAction().or(FsAction.WRITE_EXECUTE), p.getGroupAction(), p.getOtherAction());
            }
            node.setPermission(p);
        }
        if (this.children == null) {
            this.children = new ArrayList<INode>(5);
        }
        if ((low = Collections.binarySearch(this.children, node.name)) >= 0) {
            return null;
        }
        node.parent = this;
        this.children.add(-low - 1, node);
        this.setModificationTime(node.getModificationTime());
        if (node.getGroupName() == null) {
            node.setGroup(this.getGroupName());
        }
        return node;
    }

    <T extends INode> T addNode(String path, T newNode) throws FileNotFoundException {
        return this.addNode(path, newNode, false);
    }

    <T extends INode> T addNode(String path, T newNode, boolean inheritPermission) throws FileNotFoundException {
        if (this.addToParent(path, newNode, null, inheritPermission) == null) {
            return null;
        }
        return newNode;
    }

    <T extends INode> INodeDirectory addToParent(String path, T newNode, INodeDirectory parent, boolean inheritPermission) throws FileNotFoundException {
        byte[][] pathComponents = INodeDirectory.getPathComponents(path);
        assert (pathComponents != null) : "Incorrect path " + path;
        int pathLen = pathComponents.length;
        if (pathLen < 2) {
            return null;
        }
        if (parent == null) {
            INode[] inodes = new INode[2];
            this.getExistingPathINodes(pathComponents, inodes);
            INode inode = inodes[0];
            if (inode == null) {
                throw new FileNotFoundException("Parent path does not exist: " + path);
            }
            if (!inode.isDirectory()) {
                throw new FileNotFoundException("Parent path is not a directory: " + path);
            }
            parent = (INodeDirectory)inode;
        }
        newNode.name = pathComponents[pathLen - 1];
        if (parent.addChild(newNode, inheritPermission) == null) {
            return null;
        }
        return parent;
    }

    @Override
    INode.DirCounts spaceConsumedInTree(INode.DirCounts counts) {
        ++counts.nsCount;
        if (this.children != null) {
            for (INode child : this.children) {
                child.spaceConsumedInTree(counts);
            }
        }
        return counts;
    }

    @Override
    long[] computeContentSummary(long[] summary) {
        if (this.children != null) {
            for (INode child : this.children) {
                child.computeContentSummary(summary);
            }
        }
        summary[2] = summary[2] + 1L;
        return summary;
    }

    List<INode> getChildren() {
        return this.children == null ? new ArrayList() : this.children;
    }

    List<INode> getChildrenRaw() {
        return this.children;
    }

    @Override
    int collectSubtreeBlocksAndClear(List<Block> v) {
        int total = 1;
        if (this.children == null) {
            return total;
        }
        for (INode child : this.children) {
            total += child.collectSubtreeBlocksAndClear(v);
        }
        this.parent = null;
        this.children = null;
        return total;
    }
}

