/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.protocol.Block;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.namenode.NameNode;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.ipc.Server;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class CorruptReplicasMap {
    private Map<Block, Collection<DatanodeDescriptor>> corruptReplicasMap = new TreeMap<Block, Collection<DatanodeDescriptor>>();

    public void addToCorruptReplicasMap(Block blk, DatanodeDescriptor dn) {
        Collection<DatanodeDescriptor> nodes = this.getNodes(blk);
        if (nodes == null) {
            nodes = new TreeSet<DatanodeDescriptor>();
            this.corruptReplicasMap.put(blk, nodes);
        }
        if (!nodes.contains(dn)) {
            nodes.add(dn);
            NameNode.stateChangeLog.info("BLOCK NameSystem.addToCorruptReplicasMap: " + blk.getBlockName() + " added as corrupt on " + dn.getName() + " by " + Server.getRemoteIp());
        } else {
            NameNode.stateChangeLog.info("BLOCK NameSystem.addToCorruptReplicasMap: duplicate requested for " + blk.getBlockName() + " to add as corrupt " + "on " + dn.getName() + " by " + Server.getRemoteIp());
        }
    }

    void removeFromCorruptReplicasMap(Block blk) {
        if (this.corruptReplicasMap != null) {
            this.corruptReplicasMap.remove(blk);
        }
    }

    boolean removeFromCorruptReplicasMap(Block blk, DatanodeDescriptor datanode) {
        Collection<DatanodeDescriptor> datanodes = this.corruptReplicasMap.get(blk);
        if (datanodes == null) {
            return false;
        }
        if (datanodes.remove(datanode)) {
            if (datanodes.isEmpty()) {
                this.corruptReplicasMap.remove(blk);
            }
            return true;
        }
        return false;
    }

    Collection<DatanodeDescriptor> getNodes(Block blk) {
        return this.corruptReplicasMap.get(blk);
    }

    boolean isReplicaCorrupt(Block blk, DatanodeDescriptor node) {
        Collection<DatanodeDescriptor> nodes = this.getNodes(blk);
        return nodes != null && nodes.contains(node);
    }

    public int numCorruptReplicas(Block blk) {
        Collection<DatanodeDescriptor> nodes = this.getNodes(blk);
        return nodes == null ? 0 : nodes.size();
    }

    public int size() {
        return this.corruptReplicasMap.size();
    }
}

