/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.datanode.metrics;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeActivityMBean;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.metrics.MetricsContext;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.metrics.MetricsRecord;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.metrics.MetricsUtil;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.metrics.Updater;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.metrics.jvm.JvmMetrics;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.metrics.util.MetricsBase;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.metrics.util.MetricsRegistry;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.metrics.util.MetricsTimeVaryingInt;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.metrics.util.MetricsTimeVaryingLong;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;

public class DataNodeMetrics
implements Updater {
    private final MetricsRecord metricsRecord;
    private DataNodeActivityMBean datanodeActivityMBean;
    public MetricsRegistry registry = new MetricsRegistry();
    public MetricsTimeVaryingLong bytesWritten = new MetricsTimeVaryingLong("bytes_written", this.registry);
    public MetricsTimeVaryingLong bytesRead = new MetricsTimeVaryingLong("bytes_read", this.registry);
    public MetricsTimeVaryingInt blocksWritten = new MetricsTimeVaryingInt("blocks_written", this.registry);
    public MetricsTimeVaryingInt blocksRead = new MetricsTimeVaryingInt("blocks_read", this.registry);
    public MetricsTimeVaryingInt blocksReplicated = new MetricsTimeVaryingInt("blocks_replicated", this.registry);
    public MetricsTimeVaryingInt blocksRemoved = new MetricsTimeVaryingInt("blocks_removed", this.registry);
    public MetricsTimeVaryingInt blocksVerified = new MetricsTimeVaryingInt("blocks_verified", this.registry);
    public MetricsTimeVaryingInt blockVerificationFailures = new MetricsTimeVaryingInt("block_verification_failures", this.registry);
    public MetricsTimeVaryingInt readsFromLocalClient = new MetricsTimeVaryingInt("reads_from_local_client", this.registry);
    public MetricsTimeVaryingInt readsFromRemoteClient = new MetricsTimeVaryingInt("reads_from_remote_client", this.registry);
    public MetricsTimeVaryingInt writesFromLocalClient = new MetricsTimeVaryingInt("writes_from_local_client", this.registry);
    public MetricsTimeVaryingInt writesFromRemoteClient = new MetricsTimeVaryingInt("writes_from_remote_client", this.registry);
    public MetricsTimeVaryingRate readBlockOp = new MetricsTimeVaryingRate("readBlockOp", this.registry);
    public MetricsTimeVaryingRate writeBlockOp = new MetricsTimeVaryingRate("writeBlockOp", this.registry);
    public MetricsTimeVaryingRate readMetadataOp = new MetricsTimeVaryingRate("readMetadataOp", this.registry);
    public MetricsTimeVaryingRate blockChecksumOp = new MetricsTimeVaryingRate("blockChecksumOp", this.registry);
    public MetricsTimeVaryingRate copyBlockOp = new MetricsTimeVaryingRate("copyBlockOp", this.registry);
    public MetricsTimeVaryingRate replaceBlockOp = new MetricsTimeVaryingRate("replaceBlockOp", this.registry);
    public MetricsTimeVaryingRate heartbeats = new MetricsTimeVaryingRate("heartBeats", this.registry);
    public MetricsTimeVaryingRate blockReports = new MetricsTimeVaryingRate("blockReports", this.registry);

    public DataNodeMetrics(Configuration conf, String storageId) {
        String sessionId = conf.get("session.id");
        JvmMetrics.init("DataNode", sessionId);
        this.datanodeActivityMBean = new DataNodeActivityMBean(this.registry, storageId);
        MetricsContext context = MetricsUtil.getContext("dfs");
        this.metricsRecord = MetricsUtil.createRecord(context, "datanode");
        this.metricsRecord.setTag("sessionId", sessionId);
        context.registerUpdater(this);
    }

    public void shutdown() {
        if (this.datanodeActivityMBean != null) {
            this.datanodeActivityMBean.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpdates(MetricsContext unused) {
        DataNodeMetrics dataNodeMetrics = this;
        synchronized (dataNodeMetrics) {
            for (MetricsBase m : this.registry.getMetricsList()) {
                m.pushMetric(this.metricsRecord);
            }
        }
        this.metricsRecord.update();
    }

    public void resetAllMinMax() {
        this.readBlockOp.resetMinMax();
        this.writeBlockOp.resetMinMax();
        this.readMetadataOp.resetMinMax();
        this.blockChecksumOp.resetMinMax();
        this.copyBlockOp.resetMinMax();
        this.replaceBlockOp.resetMinMax();
        this.heartbeats.resetMinMax();
        this.blockReports.resetMinMax();
    }
}

