/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.datanode;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileUtil;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.protocol.Block;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.datanode.DataNode;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.datanode.FSDataset;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class DatanodeBlockInfo {
    private FSDataset.FSVolume volume;
    private File file;
    private boolean detached;

    DatanodeBlockInfo(FSDataset.FSVolume vol, File file) {
        this.volume = vol;
        this.file = file;
        this.detached = false;
    }

    DatanodeBlockInfo(FSDataset.FSVolume vol) {
        this.volume = vol;
        this.file = null;
        this.detached = false;
    }

    FSDataset.FSVolume getVolume() {
        return this.volume;
    }

    File getFile() {
        return this.file;
    }

    boolean isDetached() {
        return this.detached;
    }

    void setDetached() {
        this.detached = true;
    }

    private void detachFile(File file, Block b) throws IOException {
        File tmpFile = this.volume.createDetachFile(b, file.getName());
        try {
            IOUtils.copyBytes((InputStream)new FileInputStream(file), (OutputStream)new FileOutputStream(tmpFile), 16384, true);
            if (file.length() != tmpFile.length()) {
                throw new IOException("Copy of file " + file + " size " + file.length() + " into file " + tmpFile + " resulted in a size of " + tmpFile.length());
            }
            FileUtil.replaceFile(tmpFile, file);
        }
        catch (IOException e) {
            boolean done = tmpFile.delete();
            if (!done) {
                DataNode.LOG.info("detachFile failed to delete temporary file " + tmpFile);
            }
            throw e;
        }
    }

    boolean detachBlock(Block block, int numLinks) throws IOException {
        if (this.isDetached()) {
            return false;
        }
        if (this.file == null || this.volume == null) {
            throw new IOException("detachBlock:Block not found. " + block);
        }
        File meta = FSDataset.getMetaFile(this.file, block);
        if (meta == null) {
            throw new IOException("Meta file not found for block " + block);
        }
        if (FileUtil.HardLink.getLinkCount(this.file) > numLinks) {
            DataNode.LOG.info("CopyOnWrite for block " + block);
            this.detachFile(this.file, block);
        }
        if (FileUtil.HardLink.getLinkCount(meta) > numLinks) {
            this.detachFile(meta, block);
        }
        this.setDetached();
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(volume=" + this.volume + ", file=" + this.file + ", detached=" + this.detached + ")";
    }
}

