/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.datanode;

import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.protocol.FSConstants;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.datanode.BlockTransferThrottler;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.datanode.DataNode;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.server.datanode.DataXceiver;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.Daemon;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.StringUtils;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class DataXceiverServer
implements Runnable,
FSConstants {
    public static final Log LOG = DataNode.LOG;
    ServerSocket ss;
    DataNode datanode;
    Map<Socket, Socket> childSockets = Collections.synchronizedMap(new HashMap());
    static final int MAX_XCEIVER_COUNT = 256;
    int maxXceiverCount = 256;
    BlockBalanceThrottler balanceThrottler;
    long estimateBlockSize;

    DataXceiverServer(ServerSocket ss, Configuration conf, DataNode datanode) {
        this.ss = ss;
        this.datanode = datanode;
        this.maxXceiverCount = conf.getInt("dfs.datanode.max.xcievers", 256);
        this.estimateBlockSize = conf.getLong("dfs.block.size", 0x4000000L);
        this.balanceThrottler = new BlockBalanceThrottler(conf.getLong("dfs.balance.bandwidthPerSec", 0x100000L));
    }

    @Override
    public void run() {
        while (this.datanode.shouldRun) {
            try {
                Socket s = this.ss.accept();
                s.setTcpNoDelay(true);
                new Daemon(this.datanode.threadGroup, new DataXceiver(s, this.datanode, this)).start();
            }
            catch (SocketTimeoutException ignored) {
            }
            catch (IOException ie) {
                LOG.warn(this.datanode.dnRegistration + ":DataXceiveServer: " + StringUtils.stringifyException(ie));
            }
            catch (Throwable te) {
                LOG.error(this.datanode.dnRegistration + ":DataXceiveServer: Exiting due to:" + StringUtils.stringifyException(te));
                this.datanode.shouldRun = false;
            }
        }
        try {
            this.ss.close();
        }
        catch (IOException ie) {
            LOG.warn(this.datanode.dnRegistration + ":DataXceiveServer: " + StringUtils.stringifyException(ie));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void kill() {
        assert (!this.datanode.shouldRun) : "shoudRun should be set to false before killing";
        try {
            this.ss.close();
        }
        catch (IOException ie) {
            LOG.warn(this.datanode.dnRegistration + ":DataXceiveServer.kill(): " + StringUtils.stringifyException(ie));
        }
        Map<Socket, Socket> map = this.childSockets;
        synchronized (map) {
            for (Socket thissock : this.childSockets.values()) {
                try {
                    thissock.close();
                }
                catch (IOException e) {}
            }
        }
    }

    static class BlockBalanceThrottler
    extends BlockTransferThrottler {
        private int numThreads;

        private BlockBalanceThrottler(long bandwidth) {
            super(bandwidth);
            LOG.info("Balancing bandwith is " + bandwidth + " bytes/s");
        }

        synchronized boolean acquire() {
            if (this.numThreads >= 5) {
                return false;
            }
            ++this.numThreads;
            return true;
        }

        synchronized void release() {
            --this.numThreads;
        }
    }
}

