/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.hdfs.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public interface DataTransferProtocol {
    public static final int DATA_TRANSFER_VERSION = 14;
    public static final byte OP_WRITE_BLOCK = 80;
    public static final byte OP_READ_BLOCK = 81;
    public static final byte OP_READ_METADATA = 82;
    public static final byte OP_REPLACE_BLOCK = 83;
    public static final byte OP_COPY_BLOCK = 84;
    public static final byte OP_BLOCK_CHECKSUM = 85;
    public static final int OP_STATUS_SUCCESS = 0;
    public static final int OP_STATUS_ERROR = 1;
    public static final int OP_STATUS_ERROR_CHECKSUM = 2;
    public static final int OP_STATUS_ERROR_INVALID = 3;
    public static final int OP_STATUS_ERROR_EXISTS = 4;
    public static final int OP_STATUS_CHECKSUM_OK = 5;
    public static final int HEARTBEAT_SEQNO = -1;

    public static class PipelineAck {
        private long seqno;
        private short[] replies;
        public static final PipelineAck HEART_BEAT = new PipelineAck(-1L, new short[0]);

        public PipelineAck() {
        }

        public PipelineAck(long seqno, short[] replies) {
            this.seqno = seqno;
            this.replies = replies;
        }

        public long getSeqno() {
            return this.seqno;
        }

        public short getReply(int i) {
            return this.replies[i];
        }

        public boolean isSuccess() {
            for (short reply : this.replies) {
                if (reply == 0) continue;
                return false;
            }
            return true;
        }

        public void readFields(DataInput in, int numRepliesExpected) throws IOException {
            assert (numRepliesExpected > 0);
            this.seqno = in.readLong();
            if (this.seqno == -1L) {
                this.replies = new short[0];
            } else {
                this.replies = new short[numRepliesExpected];
                for (int i = 0; i < this.replies.length; ++i) {
                    this.replies[i] = in.readShort();
                }
            }
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.seqno);
            for (short reply : this.replies) {
                out.writeShort(reply);
            }
        }

        public String toString() {
            StringBuilder ack = new StringBuilder("Replies for seqno ");
            ack.append(this.seqno).append(" are");
            for (short reply : this.replies) {
                ack.append(" ");
                if (reply == 0) {
                    ack.append("SUCCESS");
                    continue;
                }
                ack.append("FAILED");
            }
            return ack.toString();
        }
    }
}

