/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.shell;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileSystem;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.shell.Command;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.shell.CommandFormat;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.shell.CommandUtils;
import java.io.IOException;
import java.util.List;

public class Count
extends Command {
    public static final String NAME = "count";
    public static final String USAGE = "-count[-q] <path>";
    public static final String DESCRIPTION = CommandUtils.formatDescription("-count[-q] <path>", "Count the number of directories, files and bytes under the paths", "that match the specified file pattern.  The output columns are:", "DIR_COUNT FILE_COUNT CONTENT_SIZE FILE_NAME or", "QUOTA REMAINING_QUATA SPACE_QUOTA REMAINING_SPACE_QUOTA ", "      DIR_COUNT FILE_COUNT CONTENT_SIZE FILE_NAME");
    private boolean qOption;

    public Count(String[] cmd, int pos, Configuration conf) {
        super(conf);
        CommandFormat c = new CommandFormat(NAME, 1, Integer.MAX_VALUE, "q");
        List<String> parameters = c.parse(cmd, pos);
        this.args = parameters.toArray(new String[parameters.size()]);
        if (this.args.length == 0) {
            this.args = new String[]{"."};
        }
        this.qOption = c.getOpt("q");
    }

    public static boolean matches(String cmd) {
        return "-count".equals(cmd);
    }

    @Override
    public String getCommandName() {
        return NAME;
    }

    @Override
    protected void run(Path path) throws IOException {
        FileSystem fs = path.getFileSystem(this.getConf());
        System.out.println(fs.getContentSummary(path).toString(this.qOption) + path);
    }
}

