/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.shell;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.conf.Configured;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileStatus;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileSystem;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.ipc.RemoteException;
import java.io.IOException;

public abstract class Command
extends Configured {
    protected String[] args;

    protected Command(Configuration conf) {
        super(conf);
    }

    public abstract String getCommandName();

    protected abstract void run(Path var1) throws IOException;

    public int runAll() {
        int exitCode = 0;
        for (String src : this.args) {
            try {
                Path srcPath = new Path(src);
                FileSystem fs = srcPath.getFileSystem(this.getConf());
                FileStatus[] statuses = fs.globStatus(srcPath);
                if (statuses == null) {
                    System.err.println("Can not find listing for " + src);
                    exitCode = -1;
                    continue;
                }
                for (FileStatus s : statuses) {
                    this.run(s.getPath());
                }
            }
            catch (RemoteException re) {
                exitCode = -1;
                String content = re.getLocalizedMessage();
                int eol = content.indexOf(10);
                if (eol >= 0) {
                    content = content.substring(0, eol);
                }
                System.err.println(this.getCommandName() + ": " + content);
            }
            catch (IOException e) {
                exitCode = -1;
                System.err.println(this.getCommandName() + ": " + e.getLocalizedMessage());
            }
        }
        return exitCode;
    }
}

