/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.kfs;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FSDataInputStream;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FSDataOutputStream;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileStatus;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileSystem;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.kfs.IFSImpl;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.kfs.KFSInputStream;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.kfs.KFSOutputStream;
import java.io.IOException;
import org.kosmix.kosmosfs.access.KfsAccess;
import org.kosmix.kosmosfs.access.KfsFileAttr;

class KFSImpl
implements IFSImpl {
    private KfsAccess kfsAccess = null;
    private FileSystem.Statistics statistics;

    @Deprecated
    public KFSImpl(String metaServerHost, int metaServerPort) throws IOException {
        this(metaServerHost, metaServerPort, null);
    }

    public KFSImpl(String metaServerHost, int metaServerPort, FileSystem.Statistics stats) throws IOException {
        this.kfsAccess = new KfsAccess(metaServerHost, metaServerPort);
        this.statistics = stats;
    }

    @Override
    public boolean exists(String path) throws IOException {
        return this.kfsAccess.kfs_exists(path);
    }

    @Override
    public boolean isDirectory(String path) throws IOException {
        return this.kfsAccess.kfs_isDirectory(path);
    }

    @Override
    public boolean isFile(String path) throws IOException {
        return this.kfsAccess.kfs_isFile(path);
    }

    @Override
    public String[] readdir(String path) throws IOException {
        return this.kfsAccess.kfs_readdir(path);
    }

    @Override
    public FileStatus[] readdirplus(Path path) throws IOException {
        String srep = path.toUri().getPath();
        KfsFileAttr[] fattr = this.kfsAccess.kfs_readdirplus(srep);
        if (fattr == null) {
            return null;
        }
        int numEntries = 0;
        for (int i = 0; i < fattr.length; ++i) {
            if (fattr[i].filename.compareTo(".") == 0 || fattr[i].filename.compareTo("..") == 0) continue;
            ++numEntries;
        }
        FileStatus[] fstatus = new FileStatus[numEntries];
        int j = 0;
        for (int i = 0; i < fattr.length; ++i) {
            if (fattr[i].filename.compareTo(".") == 0 || fattr[i].filename.compareTo("..") == 0) continue;
            Path fn = new Path(path, fattr[i].filename);
            fstatus[j] = fattr[i].isDirectory ? new FileStatus(0L, true, 1, 0L, fattr[i].modificationTime, fn) : new FileStatus(fattr[i].filesize, fattr[i].isDirectory, fattr[i].replication, 0x4000000L, fattr[i].modificationTime, fn);
            ++j;
        }
        return fstatus;
    }

    @Override
    public int mkdirs(String path) throws IOException {
        return this.kfsAccess.kfs_mkdirs(path);
    }

    @Override
    public int rename(String source, String dest) throws IOException {
        return this.kfsAccess.kfs_rename(source, dest);
    }

    @Override
    public int rmdir(String path) throws IOException {
        return this.kfsAccess.kfs_rmdir(path);
    }

    @Override
    public int remove(String path) throws IOException {
        return this.kfsAccess.kfs_remove(path);
    }

    @Override
    public long filesize(String path) throws IOException {
        return this.kfsAccess.kfs_filesize(path);
    }

    @Override
    public short getReplication(String path) throws IOException {
        return this.kfsAccess.kfs_getReplication(path);
    }

    @Override
    public short setReplication(String path, short replication) throws IOException {
        return this.kfsAccess.kfs_setReplication(path, (int)replication);
    }

    @Override
    public String[][] getDataLocation(String path, long start, long len) throws IOException {
        return this.kfsAccess.kfs_getDataLocation(path, start, len);
    }

    @Override
    public long getModificationTime(String path) throws IOException {
        return this.kfsAccess.kfs_getModificationTime(path);
    }

    @Override
    public FSDataOutputStream create(String path, short replication, int bufferSize) throws IOException {
        return new FSDataOutputStream(new KFSOutputStream(this.kfsAccess, path, replication), this.statistics);
    }

    @Override
    public FSDataInputStream open(String path, int bufferSize) throws IOException {
        return new FSDataInputStream(new KFSInputStream(this.kfsAccess, path, this.statistics));
    }
}

