/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileChecksum;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.MD5Hash;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.znerd.xmlenc.XMLOutputter;

public class MD5MD5CRC32FileChecksum
extends FileChecksum {
    public static final int LENGTH = 28;
    private int bytesPerCRC;
    private long crcPerBlock;
    private MD5Hash md5;

    public MD5MD5CRC32FileChecksum() {
        this(0, 0L, null);
    }

    public MD5MD5CRC32FileChecksum(int bytesPerCRC, long crcPerBlock, MD5Hash md5) {
        this.bytesPerCRC = bytesPerCRC;
        this.crcPerBlock = crcPerBlock;
        this.md5 = md5;
    }

    @Override
    public String getAlgorithmName() {
        return "MD5-of-" + this.crcPerBlock + "MD5-of-" + this.bytesPerCRC + "CRC32";
    }

    @Override
    public int getLength() {
        return 28;
    }

    @Override
    public byte[] getBytes() {
        return WritableUtils.toByteArray(this);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.bytesPerCRC = in.readInt();
        this.crcPerBlock = in.readLong();
        this.md5 = MD5Hash.read(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.bytesPerCRC);
        out.writeLong(this.crcPerBlock);
        this.md5.write(out);
    }

    public static void write(XMLOutputter xml, MD5MD5CRC32FileChecksum that) throws IOException {
        xml.startTag(MD5MD5CRC32FileChecksum.class.getName());
        if (that != null) {
            xml.attribute("bytesPerCRC", "" + that.bytesPerCRC);
            xml.attribute("crcPerBlock", "" + that.crcPerBlock);
            xml.attribute("md5", "" + that.md5);
        }
        xml.endTag();
    }

    public static MD5MD5CRC32FileChecksum valueOf(Attributes attrs) throws SAXException {
        String bytesPerCRC = attrs.getValue("bytesPerCRC");
        String crcPerBlock = attrs.getValue("crcPerBlock");
        String md5 = attrs.getValue("md5");
        if (bytesPerCRC == null || crcPerBlock == null || md5 == null) {
            return null;
        }
        try {
            return new MD5MD5CRC32FileChecksum(Integer.valueOf(bytesPerCRC), Integer.valueOf(crcPerBlock).intValue(), new MD5Hash(md5));
        }
        catch (Exception e) {
            throw new SAXException("Invalid attributes: bytesPerCRC=" + bytesPerCRC + ", crcPerBlock=" + crcPerBlock + ", md5=" + md5, e);
        }
    }

    public String toString() {
        return this.getAlgorithmName() + ":" + this.md5;
    }
}

