/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs;

import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.Text;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.Writable;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.WritableFactories;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.io.WritableFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class BlockLocation
implements Writable {
    private String[] hosts;
    private String[] names;
    private String[] topologyPaths;
    private long offset;
    private long length;

    public BlockLocation() {
        this(new String[0], new String[0], 0L, 0L);
    }

    public BlockLocation(String[] names, String[] hosts, long offset, long length) {
        this.names = names == null ? new String[0] : names;
        this.hosts = hosts == null ? new String[0] : hosts;
        this.offset = offset;
        this.length = length;
        this.topologyPaths = new String[0];
    }

    public BlockLocation(String[] names, String[] hosts, String[] topologyPaths, long offset, long length) {
        this(names, hosts, offset, length);
        this.topologyPaths = topologyPaths == null ? new String[0] : topologyPaths;
    }

    public String[] getHosts() throws IOException {
        if (this.hosts == null || this.hosts.length == 0) {
            return new String[0];
        }
        return this.hosts;
    }

    public String[] getNames() throws IOException {
        if (this.names == null || this.names.length == 0) {
            return new String[0];
        }
        return this.names;
    }

    public String[] getTopologyPaths() throws IOException {
        if (this.topologyPaths == null || this.topologyPaths.length == 0) {
            return new String[0];
        }
        return this.topologyPaths;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() {
        return this.length;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setHosts(String[] hosts) throws IOException {
        this.hosts = hosts == null ? new String[0] : hosts;
    }

    public void setNames(String[] names) throws IOException {
        this.names = names == null ? new String[0] : names;
    }

    public void setTopologyPaths(String[] topologyPaths) throws IOException {
        this.topologyPaths = topologyPaths == null ? new String[0] : topologyPaths;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text host;
        int i;
        out.writeLong(this.offset);
        out.writeLong(this.length);
        out.writeInt(this.names.length);
        for (i = 0; i < this.names.length; ++i) {
            Text name = new Text(this.names[i]);
            name.write(out);
        }
        out.writeInt(this.hosts.length);
        for (i = 0; i < this.hosts.length; ++i) {
            host = new Text(this.hosts[i]);
            host.write(out);
        }
        out.writeInt(this.topologyPaths.length);
        for (i = 0; i < this.topologyPaths.length; ++i) {
            host = new Text(this.topologyPaths[i]);
            host.write(out);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.offset = in.readLong();
        this.length = in.readLong();
        int numNames = in.readInt();
        this.names = new String[numNames];
        for (int i = 0; i < numNames; ++i) {
            Text name = new Text();
            name.readFields(in);
            this.names[i] = name.toString();
        }
        int numHosts = in.readInt();
        for (int i = 0; i < numHosts; ++i) {
            Text host = new Text();
            host.readFields(in);
            this.hosts[i] = host.toString();
        }
        int numTops = in.readInt();
        Text path = new Text();
        for (int i = 0; i < numTops; ++i) {
            path.readFields(in);
            this.topologyPaths[i] = path.toString();
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.offset);
        result.append(',');
        result.append(this.length);
        for (String h : this.hosts) {
            result.append(',');
            result.append(h);
        }
        return result.toString();
    }

    static {
        WritableFactories.setFactory(BlockLocation.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new BlockLocation();
            }
        });
    }
}

