/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.org.apache.hadoop.filecache;

import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.Log;
import io.prestosql.hive.jdbc.$internal.org.apache.commons.logging.LogFactory;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.conf.Configuration;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileStatus;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileSystem;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.FileUtil;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.LocalFileSystem;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.fs.Path;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.RunJar;
import io.prestosql.hive.jdbc.$internal.org.apache.hadoop.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class DistributedCache {
    private static TreeMap<String, CacheStatus> cachedArchives = new TreeMap();
    private static TreeMap<Path, Long> baseDirSize = new TreeMap();
    private static final long DEFAULT_CACHE_SIZE = 0x280000000L;
    private static final Log LOG = LogFactory.getLog(DistributedCache.class);

    public static Path getLocalCache(URI cache, Configuration conf, Path baseDir, FileStatus fileStatus, boolean isArchive, long confFileStamp, Path currentWorkDir) throws IOException {
        return DistributedCache.getLocalCache(cache, conf, baseDir, fileStatus, isArchive, confFileStamp, currentWorkDir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path getLocalCache(URI cache, Configuration conf, Path baseDir, FileStatus fileStatus, boolean isArchive, long confFileStamp, Path currentWorkDir, boolean honorSymLinkConf) throws IOException {
        Path localizedPath;
        String cacheId = DistributedCache.makeRelative(cache, conf);
        TreeMap<String, CacheStatus> treeMap = cachedArchives;
        synchronized (treeMap) {
            CacheStatus lcacheStatus = cachedArchives.get(cacheId);
            if (lcacheStatus == null) {
                lcacheStatus = new CacheStatus(baseDir, new Path(baseDir, new Path(cacheId)));
                cachedArchives.put(cacheId, lcacheStatus);
            }
            CacheStatus cacheStatus = lcacheStatus;
            synchronized (cacheStatus) {
                localizedPath = DistributedCache.localizeCache(conf, cache, confFileStamp, lcacheStatus, fileStatus, isArchive, currentWorkDir, honorSymLinkConf);
                ++lcacheStatus.refcount;
            }
        }
        long size = 0L;
        TreeMap<Path, Long> treeMap2 = baseDirSize;
        synchronized (treeMap2) {
            Long get = baseDirSize.get(baseDir);
            if (get != null) {
                size = get;
            }
        }
        long allowedSize = conf.getLong("local.cache.size", 0x280000000L);
        if (allowedSize < size) {
            DistributedCache.deleteCache(conf);
        }
        return localizedPath;
    }

    public static Path getLocalCache(URI cache, Configuration conf, Path baseDir, boolean isArchive, long confFileStamp, Path currentWorkDir) throws IOException {
        return DistributedCache.getLocalCache(cache, conf, baseDir, null, isArchive, confFileStamp, currentWorkDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseCache(URI cache, Configuration conf) throws IOException {
        String cacheId = DistributedCache.makeRelative(cache, conf);
        TreeMap<String, CacheStatus> treeMap = cachedArchives;
        synchronized (treeMap) {
            CacheStatus lcacheStatus = cachedArchives.get(cacheId);
            if (lcacheStatus == null) {
                return;
            }
            CacheStatus cacheStatus = lcacheStatus;
            synchronized (cacheStatus) {
                --lcacheStatus.refcount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteCache(Configuration conf) throws IOException {
        TreeMap<String, CacheStatus> treeMap = cachedArchives;
        synchronized (treeMap) {
            Iterator<String> it = cachedArchives.keySet().iterator();
            while (it.hasNext()) {
                CacheStatus lcacheStatus;
                String cacheId = it.next();
                CacheStatus cacheStatus = lcacheStatus = cachedArchives.get(cacheId);
                synchronized (cacheStatus) {
                    if (lcacheStatus.refcount == 0) {
                        FileSystem.getLocal(conf).delete(lcacheStatus.localLoadPath, true);
                        TreeMap<Path, Long> treeMap2 = baseDirSize;
                        synchronized (treeMap2) {
                            Long dirSize = baseDirSize.get(lcacheStatus.baseDir);
                            if (dirSize != null) {
                                dirSize = dirSize - lcacheStatus.size;
                                baseDirSize.put(lcacheStatus.baseDir, dirSize);
                            }
                        }
                        it.remove();
                    }
                }
            }
        }
    }

    public static String makeRelative(URI cache, Configuration conf) throws IOException {
        URI defaultUri;
        String host = cache.getHost();
        if (host == null) {
            host = cache.getScheme();
        }
        if (host == null && (host = (defaultUri = FileSystem.get(conf).getUri()).getHost()) == null) {
            host = defaultUri.getScheme();
        }
        String path = host + cache.getPath();
        path = path.replace(":/", "/");
        return path;
    }

    private static Path cacheFilePath(Path p) {
        return new Path(p, p.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path localizeCache(Configuration conf, URI cache, long confFileStamp, CacheStatus cacheStatus, FileStatus fileStatus, boolean isArchive, Path currentWorkDir, boolean honorSymLinkConf) throws IOException {
        long cacheSize;
        Serializable destDir;
        boolean doSymlink;
        boolean bl = doSymlink = honorSymLinkConf && DistributedCache.getSymlink(conf);
        if (cache.getFragment() == null) {
            doSymlink = false;
        }
        FileSystem fs = DistributedCache.getFileSystem(cache, conf);
        String link = currentWorkDir.toString() + "/" + cache.getFragment();
        File flink = new File(link);
        if (DistributedCache.ifExistsAndFresh(conf, fs, cache, confFileStamp, cacheStatus, fileStatus)) {
            if (isArchive) {
                if (doSymlink && !flink.exists()) {
                    FileUtil.symLink(cacheStatus.localLoadPath.toString(), link);
                }
                return cacheStatus.localLoadPath;
            }
            if (doSymlink && !flink.exists()) {
                FileUtil.symLink(DistributedCache.cacheFilePath(cacheStatus.localLoadPath).toString(), link);
            }
            return DistributedCache.cacheFilePath(cacheStatus.localLoadPath);
        }
        if (cacheStatus.refcount > 1 && cacheStatus.currentStatus) {
            throw new IOException("Cache " + cacheStatus.localLoadPath.toString() + " is in use and cannot be refreshed");
        }
        LocalFileSystem localFs = FileSystem.getLocal(conf);
        ((FileSystem)localFs).delete(cacheStatus.localLoadPath, true);
        TreeMap<Path, Long> treeMap = baseDirSize;
        synchronized (treeMap) {
            Long dirSize = baseDirSize.get(cacheStatus.baseDir);
            if (dirSize != null) {
                dirSize = dirSize - cacheStatus.size;
                baseDirSize.put(cacheStatus.baseDir, dirSize);
            }
        }
        Path parchive = new Path(cacheStatus.localLoadPath, new Path(cacheStatus.localLoadPath.getName()));
        if (!((FileSystem)localFs).mkdirs(cacheStatus.localLoadPath)) {
            throw new IOException("Mkdirs failed to create directory " + cacheStatus.localLoadPath.toString());
        }
        String cacheId = cache.getPath();
        fs.copyToLocalFile(new Path(cacheId), parchive);
        if (isArchive) {
            String tmpArchive = parchive.toString().toLowerCase();
            File srcFile = new File(parchive.toString());
            destDir = new File(parchive.getParent().toString());
            if (tmpArchive.endsWith(".jar")) {
                RunJar.unJar(srcFile, destDir);
            } else if (tmpArchive.endsWith(".zip")) {
                FileUtil.unZip(srcFile, destDir);
            } else if (DistributedCache.isTarFile(tmpArchive)) {
                FileUtil.unTar(srcFile, destDir);
            }
        }
        cacheStatus.size = cacheSize = FileUtil.getDU(new File(parchive.getParent().toString()));
        destDir = baseDirSize;
        synchronized (destDir) {
            Long dirSize = baseDirSize.get(cacheStatus.baseDir);
            dirSize = dirSize == null ? Long.valueOf(cacheSize) : Long.valueOf(dirSize + cacheSize);
            baseDirSize.put(cacheStatus.baseDir, dirSize);
        }
        try {
            FileUtil.chmod(parchive.toString(), "+x");
        }
        catch (InterruptedException e) {
            LOG.warn("Exception in chmod" + e.toString());
        }
        cacheStatus.currentStatus = true;
        cacheStatus.mtime = DistributedCache.getTimestamp(conf, cache);
        if (isArchive) {
            if (doSymlink && !flink.exists()) {
                FileUtil.symLink(cacheStatus.localLoadPath.toString(), link);
            }
            return cacheStatus.localLoadPath;
        }
        if (doSymlink && !flink.exists()) {
            FileUtil.symLink(DistributedCache.cacheFilePath(cacheStatus.localLoadPath).toString(), link);
        }
        return DistributedCache.cacheFilePath(cacheStatus.localLoadPath);
    }

    private static boolean isTarFile(String filename) {
        return filename.endsWith(".tgz") || filename.endsWith(".tar.gz") || filename.endsWith(".tar");
    }

    private static boolean ifExistsAndFresh(Configuration conf, FileSystem fs, URI cache, long confFileStamp, CacheStatus lcacheStatus, FileStatus fileStatus) throws IOException {
        if (!lcacheStatus.currentStatus) {
            return false;
        }
        long dfsFileStamp = fileStatus != null ? fileStatus.getModificationTime() : DistributedCache.getTimestamp(conf, cache);
        if (dfsFileStamp != confFileStamp) {
            LOG.fatal("File: " + cache + " has changed on HDFS since job started");
            throw new IOException("File: " + cache + " has changed on HDFS since job started");
        }
        return dfsFileStamp == lcacheStatus.mtime;
    }

    public static long getTimestamp(Configuration conf, URI cache) throws IOException {
        FileSystem fileSystem = FileSystem.get(cache, conf);
        Path filePath = new Path(cache.getPath());
        return fileSystem.getFileStatus(filePath).getModificationTime();
    }

    public static void createAllSymlink(Configuration conf, File jobCacheDir, File workDir) throws IOException {
        if (jobCacheDir == null || !jobCacheDir.isDirectory() || workDir == null || !workDir.isDirectory()) {
            return;
        }
        boolean createSymlink = DistributedCache.getSymlink(conf);
        if (createSymlink) {
            File[] list = jobCacheDir.listFiles();
            for (int i = 0; i < list.length; ++i) {
                FileUtil.symLink(list[i].getAbsolutePath(), new File(workDir, list[i].getName()).toString());
            }
        }
    }

    private static String getFileSysName(URI url) {
        String fsname = url.getScheme();
        if ("hdfs".equals(fsname)) {
            String host = url.getHost();
            int port = url.getPort();
            return port == -1 ? host : host + ":" + port;
        }
        return null;
    }

    private static FileSystem getFileSystem(URI cache, Configuration conf) throws IOException {
        String fileSysName = DistributedCache.getFileSysName(cache);
        if (fileSysName != null) {
            return FileSystem.getNamed(fileSysName, conf);
        }
        return FileSystem.get(conf);
    }

    public static void setCacheArchives(URI[] archives, Configuration conf) {
        String sarchives = StringUtils.uriToString(archives);
        conf.set("mapred.cache.archives", sarchives);
    }

    public static void setCacheFiles(URI[] files, Configuration conf) {
        String sfiles = StringUtils.uriToString(files);
        conf.set("mapred.cache.files", sfiles);
    }

    public static URI[] getCacheArchives(Configuration conf) throws IOException {
        return StringUtils.stringToURI(conf.getStrings("mapred.cache.archives"));
    }

    public static URI[] getCacheFiles(Configuration conf) throws IOException {
        return StringUtils.stringToURI(conf.getStrings("mapred.cache.files"));
    }

    public static Path[] getLocalCacheArchives(Configuration conf) throws IOException {
        return StringUtils.stringToPath(conf.getStrings("mapred.cache.localArchives"));
    }

    public static Path[] getLocalCacheFiles(Configuration conf) throws IOException {
        return StringUtils.stringToPath(conf.getStrings("mapred.cache.localFiles"));
    }

    public static String[] getArchiveTimestamps(Configuration conf) {
        return conf.getStrings("mapred.cache.archives.timestamps");
    }

    public static String[] getFileTimestamps(Configuration conf) {
        return conf.getStrings("mapred.cache.files.timestamps");
    }

    public static void setArchiveTimestamps(Configuration conf, String timestamps) {
        conf.set("mapred.cache.archives.timestamps", timestamps);
    }

    public static void setFileTimestamps(Configuration conf, String timestamps) {
        conf.set("mapred.cache.files.timestamps", timestamps);
    }

    public static void setLocalArchives(Configuration conf, String str) {
        conf.set("mapred.cache.localArchives", str);
    }

    public static void setLocalFiles(Configuration conf, String str) {
        conf.set("mapred.cache.localFiles", str);
    }

    public static void addCacheArchive(URI uri, Configuration conf) {
        String archives = conf.get("mapred.cache.archives");
        conf.set("mapred.cache.archives", archives == null ? uri.toString() : archives + "," + uri.toString());
    }

    public static void addCacheFile(URI uri, Configuration conf) {
        String files = conf.get("mapred.cache.files");
        conf.set("mapred.cache.files", files == null ? uri.toString() : files + "," + uri.toString());
    }

    public static void addFileToClassPath(Path file, Configuration conf) throws IOException {
        String classpath = conf.get("mapred.job.classpath.files");
        conf.set("mapred.job.classpath.files", classpath == null ? file.toString() : classpath + System.getProperty("path.separator") + file.toString());
        FileSystem fs = FileSystem.get(conf);
        URI uri = fs.makeQualified(file).toUri();
        DistributedCache.addCacheFile(uri, conf);
    }

    public static Path[] getFileClassPaths(Configuration conf) {
        String classpath = conf.get("mapred.job.classpath.files");
        if (classpath == null) {
            return null;
        }
        ArrayList<Object> list = Collections.list(new StringTokenizer(classpath, System.getProperty("path.separator")));
        Path[] paths = new Path[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            paths[i] = new Path((String)list.get(i));
        }
        return paths;
    }

    public static void addArchiveToClassPath(Path archive, Configuration conf) throws IOException {
        String classpath = conf.get("mapred.job.classpath.archives");
        conf.set("mapred.job.classpath.archives", classpath == null ? archive.toString() : classpath + System.getProperty("path.separator") + archive.toString());
        FileSystem fs = FileSystem.get(conf);
        URI uri = fs.makeQualified(archive).toUri();
        DistributedCache.addCacheArchive(uri, conf);
    }

    public static Path[] getArchiveClassPaths(Configuration conf) {
        String classpath = conf.get("mapred.job.classpath.archives");
        if (classpath == null) {
            return null;
        }
        ArrayList<Object> list = Collections.list(new StringTokenizer(classpath, System.getProperty("path.separator")));
        Path[] paths = new Path[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            paths[i] = new Path((String)list.get(i));
        }
        return paths;
    }

    public static void createSymlink(Configuration conf) {
        conf.set("mapred.create.symlink", "yes");
    }

    public static boolean getSymlink(Configuration conf) {
        String result = conf.get("mapred.create.symlink");
        return "yes".equals(result);
    }

    public static boolean checkURIs(URI[] uriFiles, URI[] uriArchives) {
        if (uriFiles == null && uriArchives == null) {
            return true;
        }
        if (uriFiles != null) {
            for (int i = 0; i < uriFiles.length; ++i) {
                String frag2;
                int j;
                String frag1 = uriFiles[i].getFragment();
                if (frag1 == null) {
                    return false;
                }
                for (j = i + 1; j < uriFiles.length; ++j) {
                    frag2 = uriFiles[j].getFragment();
                    if (frag2 == null) {
                        return false;
                    }
                    if (!frag1.equalsIgnoreCase(frag2)) continue;
                    return false;
                }
                if (uriArchives == null) continue;
                for (j = 0; j < uriArchives.length; ++j) {
                    frag2 = uriArchives[j].getFragment();
                    if (frag2 == null) {
                        return false;
                    }
                    if (frag1.equalsIgnoreCase(frag2)) {
                        return false;
                    }
                    for (int k = j + 1; k < uriArchives.length; ++k) {
                        String frag3 = uriArchives[k].getFragment();
                        if (frag3 == null) {
                            return false;
                        }
                        if (!frag2.equalsIgnoreCase(frag3)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purgeCache(Configuration conf) throws IOException {
        TreeMap<String, CacheStatus> treeMap = cachedArchives;
        synchronized (treeMap) {
            LocalFileSystem localFs = FileSystem.getLocal(conf);
            for (Map.Entry<String, CacheStatus> f : cachedArchives.entrySet()) {
                try {
                    ((FileSystem)localFs).delete(f.getValue().localLoadPath, true);
                }
                catch (IOException ie) {
                    LOG.debug("Error cleaning up cache", ie);
                }
            }
            cachedArchives.clear();
        }
    }

    private static class CacheStatus {
        boolean currentStatus = false;
        Path localLoadPath;
        Path baseDir;
        long size;
        int refcount;
        long mtime;

        public CacheStatus(Path baseDir, Path localLoadPath) {
            this.localLoadPath = localLoadPath;
            this.refcount = 0;
            this.mtime = -1L;
            this.baseDir = baseDir;
            this.size = 0L;
        }
    }
}

