/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hive.jdbc.$internal.com.google.common.hash;

import io.prestosql.hive.jdbc.;
import io.prestosql.hive.jdbc.$internal.com.google.common.base.Preconditions;
import io.prestosql.hive.jdbc.$internal.com.google.common.hash.Funnel;
import io.prestosql.hive.jdbc.$internal.com.google.common.hash.Hashing;
import io.prestosql.hive.jdbc.$internal.com.google.common.math.IntMath;
import java.math.RoundingMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum BloomFilterStrategies implements .BloomFilter.Strategy
{
    MURMUR128_MITZ_32{

        @Override
        public <T> void put(T object, Funnel<? super T> funnel, int numHashFunctions, BitArray bits) {
            long hash64 = Hashing.murmur3_128().newHasher().putObject(object, funnel).hash().asLong();
            int hash1 = (int)hash64;
            int hash2 = (int)(hash64 >>> 32);
            for (int i = 1; i <= numHashFunctions; ++i) {
                int nextHash = hash1 + i * hash2;
                if (nextHash < 0) {
                    nextHash ^= 0xFFFFFFFF;
                }
                bits.set(nextHash % bits.size());
            }
        }

        @Override
        public <T> boolean mightContain(T object, Funnel<? super T> funnel, int numHashFunctions, BitArray bits) {
            long hash64 = Hashing.murmur3_128().newHasher().putObject(object, funnel).hash().asLong();
            int hash1 = (int)hash64;
            int hash2 = (int)(hash64 >>> 32);
            for (int i = 1; i <= numHashFunctions; ++i) {
                int nextHash = hash1 + i * hash2;
                if (nextHash < 0) {
                    nextHash ^= 0xFFFFFFFF;
                }
                if (bits.get(nextHash % bits.size())) continue;
                return false;
            }
            return true;
        }
    };


    static class BitArray {
        final long[] data;

        BitArray(int bits) {
            this(new long[IntMath.divide(bits, 64, RoundingMode.CEILING)]);
        }

        BitArray(long[] data) {
            Preconditions.checkArgument(data.length > 0, "data length is zero!");
            this.data = data;
        }

        void set(int index) {
            int n = index >> 6;
            this.data[n] = this.data[n] | 1L << index;
        }

        boolean get(int index) {
            return (this.data[index >> 6] & 1L << index) != 0L;
        }

        int size() {
            return this.data.length * 64;
        }
    }
}

