#!/usr/bin/python
"""reducer.py"""

import sys

current_country = None
current_sum = 0
count = 0

# input comes from STDIN
for line in sys.stdin:
    # remove leading and trailing whitespace
    line = line.strip()

    # parse the input we got from mapper.py
    country, rate = line.split('\t', 1)
    
    # convert rate to float
    try:
        rate = float(rate)
    except ValueError:
        # rate was not a number, so silently
        # ignore/discard this line
        continue
    
    if current_country == country:
        current_sum += rate
        count += 1
    else:
        if current_country:
            # write result to STDOUT, which is the sum divided by the number of values
            print('%s\t%s' % (current_country, current_sum/count))
        current_sum = rate
        current_country = country
        count = 1

# do not forget to output the last country if needed!
if current_country == country:
    print('%s\t%s' % (current_country, current_sum/count))