#!/usr/bin/python
"""currency_mapper.py`"""

import sys

# input comes from STDIN (standard input)
for line in sys.stdin:
    # remove leading and trailing whitespace
    line = line.strip()
    # We skip the header line
    if line.startswith('Date'):
        continue
    # split the line on commas
    row = line.split(',')
    # tab-delimited; emit one entry for each line with the current currency rate if values are present
    if row[1] and row[2]:
        print('%s\t%s' % (row[1], row[2]))