#ifndef MAP_H
#define MAP_H

#include<iostream>

class Map{
private:
  double** m_dMap;
  unsigned int m_dHeight;
  unsigned int m_dWidth;
public:
  Map( const unsigned int, const unsigned int );
  Map( const Map& );
  Map operator= (const Map&);
  ~Map();

  double getHeight( const unsigned int i, const unsigned int j ) const;
  void setHeight( const unsigned int i, const unsigned int j, const double h ) const;
  double getMean() const;
  double getMinHeight() const;
  double getMaxHeight() const;

  friend std::ostream &operator<<(std::ostream&, const Map&);
};

#endif