#include<iostream>
#include "Map.h"
#include <limits>


Map::Map( const unsigned int height, const unsigned int width ): m_dHeight( height ), m_dWidth( width ){

  m_dMap = new double*[ m_dHeight ];
  for ( unsigned int i = 0; i < m_dHeight; i++ ){
    m_dMap[ i ] = new double[ m_dWidth ];
  }
 
  for ( unsigned int i = 0; i < m_dHeight; i++ ){
    for ( unsigned int j = 0; j < m_dWidth; j++ ){
      m_dMap[ i ][ j ] = 0.0;
    }
  }
}

Map::Map( const Map& map ): m_dHeight( map.m_dHeight ), m_dWidth( map.m_dWidth ){
 
  m_dMap = new double*[ m_dHeight ];
  for ( unsigned int i = 0; i < m_dHeight; i++ ){
    m_dMap[ i ] = new double[ m_dWidth ];
  }
    
  for ( unsigned int i = 0; i < m_dHeight; i++ ){
    for ( unsigned int j = 0; j < m_dWidth; j++ ){
      m_dMap[ i ][ j ] = map.getHeight( i, j );
    }
  }
  
}

Map Map::operator= ( const Map& map ){
  if(this == &map){
    return *this;
  }
  
  for ( unsigned int i = 0; i < m_dHeight; i++ )
    delete[] m_dMap[ i ]; 
  delete[] m_dMap;

  m_dHeight = map.m_dHeight;
  m_dWidth = map.m_dWidth;

  m_dMap = new double*[ m_dHeight ];
  for ( unsigned int i = 0; i < m_dHeight; i++ ){
    m_dMap[ i ] = new double[ m_dWidth ];
  }
    
  for ( unsigned int i = 0; i < m_dHeight; i++ ){
    for ( unsigned int j = 0; j < m_dWidth; j++ ){
      m_dMap[ i ][ j ] = map.getHeight( i, j );
    }
  }
  
  return *this;
}

Map::~Map(){

  for ( unsigned int i = 0; i < m_dHeight; i++ ){
    delete[] m_dMap[ i ];
  }
      
  delete[] m_dMap;
}


void Map::setHeight( const unsigned int i, const unsigned int j, const double h ) const
{
  if ( i < 0 || i >= m_dHeight || j < 0 || j >= m_dWidth )
  {
    std::cout << "Index out of range! "
         << "Range: [" << this->m_dHeight - 1 << "," << this->m_dWidth - 1 << "] "
         << "Your Coords: (" << i << "," << j << ")"
         << std::endl;
    return;
  }
  this->m_dMap[ i ][ j ] = h;
}

double Map::getHeight( const unsigned int i, const unsigned int j ) const
{
  if ( i < 0 || i >= m_dHeight || j < 0 || j >= m_dWidth )
  {
    std::cout << "Index out of range! "
         << "Range: [" << this->m_dHeight - 1  << "," << this->m_dWidth - 1 << "] "
         << "Your Coords: (" << i << "," << j << ")"
         << std::endl;
    return 0.0;
  }
  
  return this->m_dMap[ i ][ j ];
}

double Map::getMean() const
{
  double sum = 0.0;
  
  for ( unsigned int i = 0; i < m_dHeight; i++ )
    for ( unsigned int j = 0; j < m_dWidth; j++ )
      sum += this->m_dMap[ i ][ j ]; 
   
  return sum / ( m_dHeight * m_dWidth );
}

double Map::getMinHeight() const
{
  double min = std::numeric_limits<double>::max( );
  
  for ( unsigned int i = 0; i < m_dHeight; i++ )
    for ( unsigned int j = 0; j < m_dWidth; j++ )
      if( min > m_dMap[ i ][ j ] )
        min = m_dMap[ i ][ j ];
        
  return min;
}

double Map::getMaxHeight() const
{
  double max = std::numeric_limits<double>::min( );
  
  for ( unsigned int i = 0; i < m_dHeight; i++ )
    for ( unsigned int j = 0; j < m_dWidth; j++ )
      if( max < m_dMap[ i ][ j ] )
        max = m_dMap[ i ][ j ];
        
  return max;
}


std::ostream &operator<<(std::ostream &os, const Map &map) {

  for ( unsigned int i = 0; i < map.m_dHeight; i++ )
  {
    for ( unsigned int j = 0; j < map.m_dWidth; j++ )
    {
      os << map.m_dMap[ i ][ j ] << " ";
    }
    os << std::endl;
  }
  
  return os;
}
