#include <iostream>
#include "Tort.h"

Tort::Tort(int szamlalo, int nevezo):_szamlalo(szamlalo),_nevezo(nevezo){
	if (nevezo == 0)
		throw "Nevezo nem lehet 0!";
}

Tort Tort::operator+ (const Tort& t){
	return Tort( _szamlalo * t._nevezo + t._szamlalo * _nevezo, _nevezo * t._nevezo);
}

Tort Tort::operator- (const Tort& t){
		return *this + (-t);
}

Tort Tort::operator* (const Tort& t){
		return Tort( _szamlalo * t._szamlalo , _nevezo * t._nevezo);
}

Tort Tort::operator/ (const Tort& t){
		if (t._szamlalo == 0) throw "Zero oszto!";
		return Tort( _szamlalo * t._nevezo , _nevezo * t._szamlalo);
}

Tort Tort::operator++(){
		_szamlalo += _nevezo;
		return *this;
}

Tort Tort::operator++(int){
		Tort elozo = *this;
		_szamlalo += _nevezo;
		return elozo;
}

Tort Tort::operator+= (const Tort& t){
		*this = (*this) + t;
		return *this;
}


bool Tort::operator==(const Tort& t){
		Tort temp = *this - t;
		return (temp._szamlalo == 0);
}

bool Tort::operator!=(const Tort& t){
		return !(*this == t);
}

bool Tort::operator>(const Tort& t){
		Tort temp = *this - t;
		return (temp._szamlalo * temp._nevezo > 0);
}

bool Tort::operator<=(const Tort& t){
		return !(*this > t);
}

bool Tort::operator<(const Tort& t){
		return (*this <= t && *this != t);
}

bool Tort::operator>=(const Tort& t){
		return !(*this < t);
}

Tort Tort::operator+(const int i){
		return Tort(_szamlalo + i*_nevezo, _nevezo);
}



Tort operator+(int i, const Tort& t){
        return Tort(i, 1) + t;
}

Tort operator-(const Tort& t)
{
        return Tort(-1,1) * t;
}

std::ostream &operator<<(std::ostream &os, const Tort &t) {
        os << "(" <<t._szamlalo << "/" << t._nevezo << ")";
        return os;
}

std::istream &operator>>(std::istream &is, Tort &t) {
        char slash;
        is >> t._szamlalo >> slash >> t._nevezo;
        if ('/' != slash) {
                std::cerr << "Hiba! Ervenytelen tortszam!" << std::endl;
                is.fail ();
        }
        return is;
}

