#ifndef Alakzat_h
#define Alakzat_h

#include<iostream>

 // Ez egy absztrakt osztly
class Alakzat {
public:
  /**
    Virtulis fggvnyek.
    Ez arra val, hogy ha egy sosztlybeli fggvny el rakjuk a virtual
    kulcsszt, az alosztlyban ltezik egy ugyanilyen nev s argumentum
    fggvmy s ha egy sosztlybeli pointerrel vagy referencival mutatunk az alosztly
    pldnyra, akkor a fggvny meghvsakor nem az sosztly, hanem az alosztly
    fggvnye fog meghvdni.
  */
  virtual void print(){ std::cout << "Ez egy alakzat, "; }
  
   // Ezek gynevezett pure virtual fggvnyek
   // Jellemzjk, hogy ha egy is van az osztlyon bell
   // akkor az osztly csak absztakt lehet, nem lehet pldnyostani
  virtual double getKerulet() = 0;
  virtual double getTerulet() = 0;
  
  /**
    Ha nem tesszk ki a virtual kulcsszt, s ugyanaz az eset ll fennt mint
    az elbb, akkor az sosztly fggvnye fog meghvdni,
    hiba is rtuk fell azt az alosztlyban.
    Plda ezekre az AlakzatMain.cpp-ben
  */
  void azonosito(){ std::cout << "Eredeti azonosito: " << rand() << std::endl; }  
};

class Kor : public Alakzat {
private:
  double m_dsugar;
public:
  Kor( double r ): m_dsugar( r ){}
  ~Kor(){}
  void print();
  double getKerulet();
  double getTerulet();
  void azonosito(){ std::cout << "Felulirt azonosito: " << rand() << std::endl; }
};

class Negyzet : public Alakzat {
private:
  double m_da;
public:
  Negyzet( double a ): m_da( a ){}
  ~Negyzet(){}
  void print();
  double getKerulet();
  double getTerulet();
  void azonosito(){ std::cout << "Felulirt azonosito: " << rand() << std::endl; } 
};

/**
  Feladat:
    rjuk meg a rombusz osztly hasonlkppen
    Rombusznak legyen:
        - 3 double adattagja: tl1, tl2, oldalhossz
        (Rombusz terlete T = 1/2 * tl1 * tl2;
                 kerlete K = 4 * oldalhossz;)
    - mainben hozzunk ltre egy pldnyt amelynek oldalhossza 3, tli 4.24 hosszak.
    - hvjuk meg r a print s az azonost fggvnyeket
*/

#endif