#include <iostream>
using namespace std;

class Allat {
protected:
    int eletkor;
    int tomeg;
public:
    Allat(int eletkor = 0, int tomeg = 0) : eletkor(eletkor), tomeg(tomeg){
    }

    int getEletkor() const { return this->eletkor; }
    int getTomeg() const { return this->tomeg; }

    void setEletkor(const int eletkor) { this->eletkor = eletkor; }
    void setTomeg(const int tomeg) { this->tomeg = tomeg; }

};

class Macska : public Allat {
    //privt lthatsg, azaz csak osztlyon bell lthat.
private:
    int nyavogasSzamlalo;

    // A kvetkez fggvnyek, adattagok public elrsek - mindenki hozzfrhet
public:

    // Alaprtelmezett konstruktor
    Macska() : Allat(0, 0), nyavogasSzamlalo(0) {
        cout << "Letrejott egy macska! Cime: " << this << endl;
    }

    // Tlterhelt konstruktor - 2 paramteres
    Macska(const int eletkor, const int tomeg) : Allat(eletkor, tomeg), nyavogasSzamlalo(0) {
        cout << "Letrejott egy macska! Cime: " << this << endl;
    }

    // Copy konstruktor - objektum lemsolsa a cl
    Macska(const Macska& macska){
        cout << "Lemasolunk egy macskt! Eredeti macska cime:" << &macska << ", masolat cime: " << this << endl;
        this->nyavogasSzamlalo = macska.nyavogasSzamlalo;
        this->eletkor = macska.eletkor;
        this->tomeg = macska.tomeg;
    }

    // Destruktorok - az objektum trlsekor hvdik meg
    //  - cljuk a lefoglalt memrik felszabadtsa, fjlok lezrsa, stb
    ~Macska() {
        cout << "kitorlunk egy macskat az univerzumbol! Cime: " << this << endl;
    }

    // Egy metdus
    void nyavog();
    void mennyitNyavogott();
};

//A cica osztly nyavog() metdusnak megvalstsa
void Macska::nyavog() {
    cout << "Miauuuu" << endl;
    this->nyavogasSzamlalo++;
}

void Macska::mennyitNyavogott(){
    cout << "A cica eddig " << nyavogasSzamlalo << " alkalommal nyavogott." << endl;
}

void printMacska(Macska macska) {
    cout << "---- Meghivodott a printMacska fuggveny" << endl;
    macska.mennyitNyavogott();
}

void printMacskaPointer(Macska* macska) {
    cout << "---- Meghivodott a printMacskaPointer fuggveny" << endl;
    macska->mennyitNyavogott();
}

void printMacskaRef(Macska& macska) {
    cout << "---- Meghivodott a printMacskaRef fuggveny" << endl;
    macska.mennyitNyavogott();
}

int main() {

    Macska m3(1, 10);
    cout << "----------" << endl;
    printMacska(m3);
    // printMacskaPointer(&m3);
    cout << "----------" << endl;

    Macska* cirmi = new Macska(3, 9);
    // printMacska(*cirmi);
    printMacskaPointer(cirmi);

    Macska& cirmike = *cirmi;
    Macska& m3ka = m3;

    printMacskaRef(m3);
    printMacskaRef(*cirmi);

    return 0;
}
