#include <iostream>
using namespace std;


class Macska {
    //privát láthatóság, azaz csak osztályon belül látható.
private:
    int nyavogasSzamlalo;

    // A következő függvények, adattagok public elérésűek - mindenki hozzáférhet
public:

    // Alapértelmezett konstruktor
    Macska() : eletkor(0), tomeg(0), nyavogasSzamlalo(0) {
        cout << "Letrejott egy macska! Cime: " << this << endl;
    }

    // Túlterhelt konstruktor - 2 paraméteres
    Macska(const int eletkor, const int tomeg) : eletkor(eletkor), tomeg(tomeg), nyavogasSzamlalo(0) {
        cout << "Letrejott egy macska! Cime: " << this << endl;
    }

    // Copy konstruktor - objektum lemásolása a cél
    Macska(const Macska& macska){
        cout << "Lemasolunk egy macskát! Eredeti macska cime:" << &macska << ", masolat cime: " << this <<  endl;
        this->nyavogasSzamlalo = macska.nyavogasSzamlalo;
        this->eletkor = macska.eletkor;
        this->tomeg = macska.tomeg;
    }

    // Destruktorok - az objektum törlésekor hívódik meg
    //  - céljuk a lefoglalt memóriák felszabadítása, fájlok lezárása, stb
    ~Macska() {
        cout << "kitorlunk egy macskat az univerzumbol! Cime: "<< this << endl;
    }

    // Egy metódus
    void nyavog();
    void mennyitNyavogott();

    int getEletkor() const { return this->eletkor; }
    int getTomeg() const { return this->tomeg; }

    void setEletkor(const int eletkor) { this->eletkor = eletkor; }
    void setTomeg(const int tomeg) { this->tomeg = tomeg; }

    int eletkor;
    int tomeg;
};

//A cica osztály nyavog() metódusának megvalósítása
void Macska::nyavog() {
    cout << "Miauuuu" << endl;
    this->nyavogasSzamlalo++;
}

void Macska::mennyitNyavogott(){
    cout << "A cica eddig " << nyavogasSzamlalo << " alkalommal nyavogott." << endl;
}

void printMacska(Macska macska) {
    cout << "---- Meghivodott a printMacska fuggveny" << endl;
    macska.mennyitNyavogott();
}

void printMacskaPointer(Macska* macska) {
    cout << "---- Meghivodott a printMacskaPointer fuggveny" << endl;
    macska->mennyitNyavogott();
}

void printMacskaRef(Macska& macska) {
    cout << "---- Meghivodott a printMacskaRef fuggveny" << endl;
    macska.mennyitNyavogott();
}

int main() {

    Macska m3(1, 10);
    cout << "----------" << endl;
    printMacska(m3);
    // printMacskaPointer(&m3);
    cout << "----------" << endl;

    Macska* cirmi = new Macska(3, 9);
    // printMacska(*cirmi);
    printMacskaPointer(cirmi);

    printMacskaRef(m3);
    printMacskaRef(*cirmi);
    
    delete cirmi;
    return 0;
}
