#include <iostream>
using namespace std;


class Macska {
    //privát láthatóság, azaz csak osztályon belül látható.
private:
    int nyavogasSzamlalo;

    // A következő függvények, adattagok public elérésűek - mindenki hozzáférhet
public:

    // Alapértelmezett konstruktor
    Macska() : eletkor(0), tomeg(0), nyavogasSzamlalo(0) {}

    // Túlterhelt konstruktor - 2 paraméteres
    Macska(const int eletkor, const int tomeg) : eletkor(eletkor), tomeg(tomeg), nyavogasSzamlalo(0) {}

    // Copy konstruktor - objektum lemásolása a cél
    Macska(const Macska& macska){
        cout << "Lemásolunk egy macskát!" << endl;
        this->nyavogasSzamlalo = macska.nyavogasSzamlalo;
        this->eletkor = macska.eletkor;
        this->tomeg = macska.tomeg;
    }

    // Destruktorok - az objektum törlésekor hívódik meg
    //  - céljuk a lefoglalt memóriák felszabadítása, fájlok lezárása, stb
    ~Macska() {
        cout << "kitorlunk egy macskat az univerzumbol" << endl;
    }   

    // Egy metódus
    void nyavog();
    void mennyitNyavogott();

    int getEletkor() const { return this->eletkor; }
    int getTomeg() const { return this->tomeg; }

    void setEletkor(const int eletkor) { this->eletkor = eletkor; }
    void setTomeg(const int tomeg) { this->tomeg = tomeg; }

    int eletkor;
    int tomeg;
};

//A cica osztály nyavog() metódusának megvalósítása
void Macska::nyavog() {
    cout << "Miauuuu" << endl;
    this->nyavogasSzamlalo++;
}

void Macska::mennyitNyavogott(){
    cout << "A cica eddig " << nyavogasSzamlalo << " alkalommal nyavogott." << endl;
}

int main() {
    Macska cic1(5, 12);

    cout << "A cic1 " << cic1.getTomeg() << "kg es " << cic1.getEletkor() << " eves." << endl;

    // Mivel a Macska osztály adattagjai public elérésűek, direkten is hozzáférünk azokhoz
    cout << "A cic1 " << cic1.tomeg << "kg es " << cic1.eletkor << " eves." << endl;

    cic1.mennyitNyavogott();

    cic1.nyavog();

    cic1.mennyitNyavogott();

    Macska kormi = cic1;
    kormi.mennyitNyavogott();

    /////////////////////////////////////
    // Stack
    Macska m2;
    Macska m3(1, 10);

    // Heap
    Macska* m4 = new Macska;
    Macska* m5 = new Macska(2, 7);

    delete m4;
    delete m5;

    return 0;
}
