// Objektumok ltrehozsa, hasznlata
//
#include <iostream>
using namespace std;

// Egy Tv osztly DEKLARLSA
class Tv {
    // A kvetkez fggvnyeket, adattagokat mindenki elrheti
public:
    // bels tpus definilsa
    typedef enum { Katod, LCD, Plazma } TvTipus;

    // Alaprtelmezett konstruktor - paramter nlkli
    //  a tagokat deklarlsuk sorrendjben inicializljuk
    Tv() : csatornak_szama(0), jelenlegi_csatorna(0), tipus(Katod) { cout << "Tv konstruktor" << endl; }

    // Tlterhelt ( overloaded ) konstruktor - ennek mr 3 paramtere van
    Tv(const int cs_sz, const int j_cs, const TvTipus tipus);

    // Destruktor - az objektum megszntetsekor hvdik meg
    ~Tv() { cout << "Tv destruktor" << endl; }

    // Mivel az adattagok private elrsek, un. setter s getter ( accessor s modifier ) metdusokat biztostunk
    // A getterek const fggvnyek ( az objektumot nem mdosthatjk )
    int getCsatornakSzama() const { return csatornak_szama; }
    int getJelenlegiCsatorna() const { return jelenlegi_csatorna; }
    void getTipus() const;

    void setCsatornakSzama(const int cs_sz) { csatornak_szama = cs_sz; }
    void setJelenlegiCsatorna(const int jelenlegi_csatorna) { this->jelenlegi_csatorna = jelenlegi_csatorna; }
    void setTipus(const TvTipus tipus) { this->tipus = tipus; }

    // A kvetkez fggvnyeket, adattagokat csak az osztly metdusai rhetik el
private:
    int csatornak_szama;
    int jelenlegi_csatorna;
    TvTipus tipus;
};

// A Tv osztly tlterhelt konstruktornak implementcija inline-knt
// Az utols kt paramternek alaprtelmezett rtke van
// -> vannak mostmr 0,1,2, illetve 3 paramteres konstruktoraink
inline Tv::Tv(const int cs_sz, const int j_cs = 1, const TvTipus tipus = LCD) {
    cout << "3 paramteres Tv konstruktor" << endl;
    this->csatornak_szama = cs_sz;
    this->jelenlegi_csatorna = j_cs;
    this->tipus = tipus;
}

void Tv::getTipus() const {
    switch (this->tipus) {
        case Katod: cout << "A Tv katdsugrcsves." << endl; break;
        case LCD: cout << "A Tv LCD monitoros." << endl; break;
        case Plazma: cout << "Plazma Tv-d van!" << endl; break;
        default: cout << "Ismeretlen tv-tpus!" << endl; break;
    }
}

int main() {
    Tv tv1;
    tv1.getTipus();

    Tv tv2(20, 1, Tv::Plazma);
    tv2.getTipus();
    tv2.setTipus(Tv::LCD);
    tv2.getTipus();

    return 0;
}